/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.impl.profile.ldap;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class DomainResolver {
    private static final Joiner JOINER = Joiner.on((char)'.').skipNulls();
    @CheckForNull
    private final String _defaultDomain;

    public DomainResolver(@Nullable String defaultDomain) {
        this._defaultDomain = Strings.emptyToNull((String)defaultDomain);
    }

    @Nonnull
    public String getDomain(@Nonnull Name distinguishedName) throws InvalidNameException {
        if (this._defaultDomain != null) {
            return this._defaultDomain;
        }
        LdapName dn = distinguishedName instanceof LdapName ? (LdapName)distinguishedName : new LdapName(distinguishedName.toString());
        ImmutableList domain = (ImmutableList)dn.getRdns().stream().filter(rdn -> rdn.getType().equalsIgnoreCase("dc")).map(Rdn::getValue).map(Rdn::escapeValue).collect(ImmutableList.toImmutableList());
        if (!domain.isEmpty()) {
            return JOINER.join((Iterable)Lists.reverse((List)domain));
        }
        throw new InvalidNameException("Failed to extract domain from dn: No domain part found in dn " + String.valueOf(distinguishedName));
    }
}

