/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.usergroup.impl;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.justimport.domain.model.externalid.ExternalId;
import de.justsoftware.justimport.domain.model.externalid.ExternalIdMapping;
import de.justsoftware.justimport.domain.model.externalid.InternalId;
import de.justsoftware.justimport.domain.model.profile.ProfileId;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupId;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupImportModel;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ExternalIdMappingResolver {
    private final Map<ExternalId, ExternalIdMapping> _idMappings;

    public ExternalIdMappingResolver(UserGroupImportModel importModel, Function<Set<ExternalId>, Map<ExternalId, ExternalIdMapping>> idMappingProvider) {
        ImmutableSet externalIds = ImmutableSet.builder().addAll((Iterable)importModel.getMembers()).add((Object)importModel.getExternalId()).build();
        this._idMappings = idMappingProvider.apply((Set<ExternalId>)externalIds);
    }

    @Nonnull
    private <T extends InternalId> Optional<T> getInternalId(ExternalId externalId, Map<ExternalId, ExternalIdMapping> memberMappings, Class<T> aClass) {
        return Optional.ofNullable(memberMappings.get(externalId)).map(ExternalIdMapping::getInternalId).filter(aClass::isInstance).map(aClass::cast);
    }

    @CheckForNull
    ProfileId getProfileIdForExternalId(ExternalId externalId, Supplier<ProfileId> defaultSupplier) {
        return this.getInternalId(externalId, this._idMappings, ProfileId.class).orElseGet(defaultSupplier);
    }

    @Nonnull
    Optional<UserGroupId> getUserGroupIdForExternalId(ExternalId externalId) {
        return this.getInternalId(externalId, this._idMappings, UserGroupId.class);
    }
}

