/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.unboundid.scim2.common.types.Name;
import com.unboundid.scim2.common.types.UserResource;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
@JsonInclude(value=JsonInclude.Include.ALWAYS)
public record ToroUserParams(String externalId, String email, String firstName, String lastName, @Nullable String honorificPrefix, @Nullable String honorificSuffix, boolean active) {
    private final String externalId;
    private final String email;
    private final String firstName;
    private final String lastName;
    @Nullable
    private final String honorificPrefix;
    @Nullable
    private final String honorificSuffix;
    private final boolean active;

    public ToroUserParams(String externalId, String email, String firstName, String lastName, @Nullable String honorificPrefix, @Nullable String honorificSuffix, boolean active) {
        ToroUserParams.validateRequiredField((String)externalId, (String)"externalId");
        ToroUserParams.validateRequiredField((String)email, (String)"email");
        ToroUserParams.validateRequiredField((String)firstName, (String)"firstName");
        ToroUserParams.validateRequiredField((String)lastName, (String)"lastName");
        honorificPrefix = ToroUserParams.nullIfDeleteAttribute((String)honorificPrefix);
        honorificSuffix = ToroUserParams.nullIfDeleteAttribute((String)honorificSuffix);
        this.externalId = externalId;
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
        this.honorificPrefix = honorificPrefix;
        this.honorificSuffix = honorificSuffix;
        this.active = active;
    }

    public static ToroUserParams fromUserResource(UserResource user) {
        Name name = user.getName();
        return new ToroUserParams(user.getExternalId(), user.getUserName(), name.getGivenName(), name.getFamilyName(), name.getHonorificPrefix(), name.getHonorificSuffix(), ToroUserParams.toPrimitiveBool((Boolean)user.getActive()));
    }

    private static void validateRequiredField(@Nullable String value, String fieldName) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Field '%s' cannot be null", fieldName));
        }
        if (value.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("Field '%s' cannot be empty", fieldName));
        }
    }

    private static String nullIfDeleteAttribute(@Nullable String value) {
        return "JUST_SOCIAL_DELETE_ATTRIBUTE".equals(value) ? null : value;
    }

    private static boolean toPrimitiveBool(@Nullable Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public String externalId() {
        return this.externalId;
    }

    public String email() {
        return this.email;
    }

    public String firstName() {
        return this.firstName;
    }

    public String lastName() {
        return this.lastName;
    }

    @Nullable
    public String honorificPrefix() {
        return this.honorificPrefix;
    }

    @Nullable
    public String honorificSuffix() {
        return this.honorificSuffix;
    }

    public boolean active() {
        return this.active;
    }
}

