/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.predicates;

import de.justsoftware.gateway.predicates.ConditionalOnPropertyRoutePredicateFactory;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ServerWebExchange;

@Service
@ParametersAreNonnullByDefault
public class ConditionalOnPropertyRoutePredicateFactory
extends AbstractRoutePredicateFactory<PredicateFactoryConfig> {
    private final Environment _environment;

    public ConditionalOnPropertyRoutePredicateFactory(Environment env) {
        super(PredicateFactoryConfig.class);
        this._environment = env;
    }

    public Predicate<ServerWebExchange> apply(PredicateFactoryConfig config) {
        return serverWebExchange -> {
            String expectedValue = config.getExpectedValue();
            String actualValue = this._environment.getProperty(config.getProperty());
            return expectedValue.equals(actualValue);
        };
    }
}

