/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.tracking.controller;

import de.justsoftware.gateway.ids.TenantId;
import de.justsoftware.gateway.security.JustAuthToken;
import de.justsoftware.gateway.tracking.TrackingService;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import java.security.Principal;
import java.time.Duration;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.webflux.ProxyExchange;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(value={"/gateway/analytics"})
public class TrackingController {
    private static final Logger LOG = LoggerFactory.getLogger(TrackingController.class);
    private final TrackingService _trackingService;

    public TrackingController(TrackingService trackingService) {
        this._trackingService = trackingService;
    }

    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @GetMapping(value={"/track"})
    @Nonnull
    Mono<Void> track(@RequestParam(value="t") String t, @RequestHeader HttpHeaders headers, ProxyExchange<byte[]> proxy, ServerHttpRequest request, Principal principal) {
        TenantId tenantId = this.extractTenantId(principal);
        if (tenantId == null) {
            LOG.warn("no tenantId, no tracking");
            return Mono.empty();
        }
        Mono.delay((Duration)Duration.ofMillis(0L)).subscribe(l -> this._trackingService.track(t, tenantId, headers, request));
        return Mono.empty();
    }

    @CheckForNull
    private TenantId extractTenantId(Principal principal) {
        if (principal instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken)principal;
            String tenantId = (String)jwtAuthenticationToken.getCustomJwtClaims().get((Object)"tenantId");
            if (tenantId != null) {
                return TenantId.parse((String)tenantId);
            }
        } else if (principal instanceof JustAuthToken) {
            JustAuthToken token = (JustAuthToken)principal;
            return token.getTenantId();
        }
        return null;
    }
}

