/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security.filter;

import de.justsoftware.gateway.security.AuthenticationToJwtStringConverter;
import de.justsoftware.gateway.security.JustJwtProperties;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@Component
public class RefreshJustIdCookieGatewayFilterFactory
extends AbstractGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(RefreshJustIdCookieGatewayFilterFactory.class);
    private final AuthenticationToJwtStringConverter _converter;
    private final Duration _tokenLifeTimeInMinutes;
    private final Duration _tokenRefreshAge;

    public RefreshJustIdCookieGatewayFilterFactory(AuthenticationToJwtStringConverter converter, JustJwtProperties jwtProperties) {
        super(AbstractGatewayFilterFactory.NameConfig.class);
        this._converter = converter;
        this._tokenLifeTimeInMinutes = jwtProperties.getCookie().getCookieLifetime();
        this._tokenRefreshAge = Duration.ofMinutes(Math.min(jwtProperties.getCookie().getCookieAgeBeforeRefresh().toMinutes(), (long)Math.round((float)this._tokenLifeTimeInMinutes.toMinutes() / 2.0f)));
        LOG.debug("token lifetime in minutes: " + this._tokenLifeTimeInMinutes.toMinutes());
        LOG.debug("tokens get refreshed after minutes: " + this._tokenRefreshAge.toMinutes());
    }

    public GatewayFilter apply(AbstractGatewayFilterFactory.NameConfig config) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private boolean needsRefresh(@Nullable Instant expirationTime) {
        if (expirationTime == null) {
            throw new IllegalArgumentException("Jwt token does not have an expiration time.");
        }
        if (this._tokenLifeTimeInMinutes.compareTo(this._tokenRefreshAge) <= 0) {
            return true;
        }
        LOG.debug("token will expire at " + expirationTime.toString());
        Instant pointOfTokenCreation = expirationTime.minus(this._tokenLifeTimeInMinutes);
        Duration tokenAge = Duration.between(pointOfTokenCreation, Instant.now());
        LOG.debug("token age: " + tokenAge.toMinutes());
        LOG.debug("token age to refresh: " + this._tokenRefreshAge.toMinutes());
        return tokenAge.compareTo(this._tokenRefreshAge) >= 0;
    }
}

