/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.predicates;

import de.justsoftware.gateway.security.JustAuthToken;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import java.util.function.Predicate;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Service
public class NotLoggedInRoutePredicateFactory
extends AbstractRoutePredicateFactory<Object> {
    public NotLoggedInRoutePredicateFactory() {
        super(Object.class);
    }

    public AsyncPredicate<ServerWebExchange> applyAsync(Object config) {
        return serverWebExchange -> {
            Mono principal = serverWebExchange.getPrincipal();
            return principal.map(p -> !(p instanceof JwtAuthenticationToken) && !(p instanceof JustAuthToken)).switchIfEmpty(Mono.just((Object)Boolean.TRUE));
        };
    }

    public Predicate<ServerWebExchange> apply(Object config) {
        throw new UnsupportedOperationException("NotLoggedInPredicateFactory is only async.");
    }
}

