/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.kafka;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.gateway.kafka.ExternalIdKafkaPayloadDto;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ExternalIdMappingDeserializer
implements Deserializer<ExternalIdKafkaPayloadDto> {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalIdMappingDeserializer.class);
    private final ObjectMapper _jsonMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public ExternalIdKafkaPayloadDto deserialize(@Nullable String topic, @Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (ExternalIdKafkaPayloadDto)this._jsonMapper.readValue(data, ExternalIdKafkaPayloadDto.class);
        }
        catch (IOException e) {
            LOG.error("Could not parse incoming ExternalId mapping.", (Throwable)e);
            return null;
        }
    }
}

