/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.kafka;

import de.justsoftware.gateway.ids.ProfileId;
import de.justsoftware.gateway.kafka.ExternalIdKafkaPayloadDto;
import de.justsoftware.gateway.security.InMemoryExternalIdMapper;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.annotation.PartitionOffset;
import org.springframework.kafka.annotation.TopicPartition;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class ExternalIdMappingConsumer {
    private static final String EXTERNAL_ID_TOPIC = "just.persons.externalId";
    private final InMemoryExternalIdMapper _inMemoryExternalIdMapper;

    @Autowired
    public ExternalIdMappingConsumer(InMemoryExternalIdMapper inMemoryExternalIdMapper) {
        this._inMemoryExternalIdMapper = inMemoryExternalIdMapper;
    }

    @KafkaListener(topics={"just.persons.externalId"}, containerFactory="externalIdListenerContainerFactory", topicPartitions={@TopicPartition(topic="just.persons.externalId", partitions={"0"}, partitionOffsets={@PartitionOffset(partition="*", initialOffset="0")})})
    public void listen(@Header(value="kafka_receivedMessageKey") ProfileId internalId, @Payload(required=false) @Nullable ExternalIdKafkaPayloadDto payload) {
        if (payload == null) {
            this._inMemoryExternalIdMapper.removeMapping(internalId);
        } else {
            this._inMemoryExternalIdMapper.setMapping(payload.getTenantId(), payload.getExternalId(), internalId);
        }
    }
}

