/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.person.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.business.person.PersonService;
import de.justsoftware.drive.common.person.model.PersonBO;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.rest.models.Person;
import de.justsoftware.drive.rest.person.PersonFrontendService;
import de.justsoftware.drive.rest.util.PersonUtil;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PersonFrontendServiceImpl
implements PersonFrontendService {
    private final PersonService _personService;

    @ParametersAreNonnullByDefault
    @Autowired
    public PersonFrontendServiceImpl(PersonService personService) {
        this._personService = personService;
    }

    public ImmutableMap<PersonId, PersonBO> getPersons(Set<PersonId> ids) {
        return this._personService.getPersonsByIds(ids);
    }

    public ImmutableMap<PersonId, Person> getFrontendPersons(Set<PersonId> personIds) {
        ImmutableMap persons = this.getPersons(personIds);
        return FluentIterable.from(personIds).transform(id -> PersonUtil.personFromBO((Map)persons, (PersonId)id)).uniqueIndex(Person::getId);
    }
}

