/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.internal.controllers;

import de.justsoftware.drive.business.file.FilePreviewService;
import de.justsoftware.drive.business.preview.CropStrategy;
import de.justsoftware.drive.business.preview.ImagePreviewOptions;
import de.justsoftware.drive.business.preview.ImagePreviewOptionsImpl;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.file.model.FilePreviewByteSource;
import de.justsoftware.drive.rest.controllers.FilePreviewController;
import io.micrometer.observation.annotation.Observed;
import io.swagger.v3.oas.annotations.Hidden;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Hidden
@RestController
@RequestMapping(value={"/internal/previews"}, produces={"application/json"})
@ParametersAreNonnullByDefault
@Observed
public class InternalPreviewController {
    static final String API_MAPPING = "/internal/previews";
    private final FilePreviewService _filePreviewService;

    public InternalPreviewController(FilePreviewService filePreviewService) {
        this._filePreviewService = filePreviewService;
    }

    @Hidden
    @RequestMapping(value={"/previewImage/{documentId}/appIcon"}, method={RequestMethod.GET})
    @Nonnull
    public ResponseEntity<Resource> appIconImage(@PathVariable DocumentId documentId) throws IOException {
        ImagePreviewOptionsImpl previewOptions = ImagePreviewOptionsImpl.Builder.withStaticGifSupport((int)512, (int)512).cropStrategy(CropStrategy.KEEP_ASPECT_RATIO).supportedMediaTypes(new MediaType[]{MediaType.IMAGE_PNG}).build();
        FilePreviewByteSource preview = this._filePreviewService.getImage(documentId, (ImagePreviewOptions)previewOptions);
        return FilePreviewController.wrapResource((FilePreviewByteSource)preview);
    }
}

