/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.file.TempFileService;
import de.justsoftware.drive.common.file.model.TempFileId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.rest.util.MultipartUtil;
import io.swagger.v3.oas.annotations.Hidden;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/tmp"}, produces={"application/json"})
@Hidden
@ParametersAreNonnullByDefault
public class TempFileController {
    private final TempFileService _tempFileService;

    @Autowired
    public TempFileController(TempFileService tempFileService) {
        this._tempFileService = tempFileService;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/upload"})
    @Nonnull
    public ImmutableSet<TempFileId> uploadFiles(AuthorizationContext authCtx, MultipartFile ... files) {
        PersonId personId = authCtx.getPersonId();
        FluentIterable byteSources = FluentIterable.from((Object[])files).transform(MultipartUtil.MULTIPART_FILE_TO_BYTESOURCE);
        return this._tempFileService.addTempFiles((Iterable)byteSources, personId, authCtx.getNonnullTenantId()).keySet();
    }
}

