/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import de.justsoftware.drive.common.document.model.VideoTeaserId;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.TempFileBO;
import de.justsoftware.drive.common.file.model.TempFileId;
import de.justsoftware.drive.common.file.model.VirusScanStatus;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.file.TempFileCreateModel;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@ParametersAreNonnullByDefault
@Mapper
public interface TempFileMapper {
    public static final String TEMP_FILE_BO_MAP = "TempFileBOMap";

    @Insert(value={"\nINSERT INTO temp_file(id, name, storage_id, mime_type, file_size, owner, upload_date, video_teaser_id)\nVALUES (#{_id}, #{_name}, #{_storageId}, #{_mimeType}, #{_fileSize}, #{_owner}, #{_uploadDate}, #{_videoTeaserId})\n"})
    public void insertTempFile(TempFileCreateModel var1);

    @Select(value={"<script>\nSELECT tf,id, tf,name, tf.storage_id, tf,mime_type, tf.file_size, tf.owner, tf.upload_date, tf.video_teaser_id,\n       vs.status as virus_scan_status\nFROM temp_file tf\nJOIN virus_scan_status vs ON vs.storage_id = tf.storage_id\nWHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)\n</script>\n"})
    @ResultType(value=TempFileBO.class)
    @ConstructorArgs(value={@Arg(column="id", id=true, javaType=TempFileId.class), @Arg(column="name", javaType=String.class), @Arg(column="owner", javaType=PersonId.class), @Arg(column="storage_id", javaType=StorageId.class), @Arg(column="mime_type", javaType=String.class), @Arg(column="file_size", javaType=long.class), @Arg(column="upload_date", javaType=Instant.class), @Arg(column="video_teaser_id", javaType=VideoTeaserId.class), @Arg(column="virus_scan_status", javaType=VirusScanStatus.class)})
    @Results(id="TempFileBOMap")
    public void getByIds(ResultHandler<TempFileBO> var1, @Param(value="ids") List<TempFileId> var2);

    @Delete(value={"<script>", "DELETE FROM temp_file WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void deleteByIds(@Param(value="ids") List<TempFileId> var1);

    @Select(value={"SELECT tf.id, tf.name, tf.storage_id, tf.mime_type, tf.file_size, tf.owner, tf.upload_date, tf.video_teaser_id,\n    vs.status as virus_scan_status\nFROM temp_file tf\nJOIN virus_scan_status vs ON vs.storage_id = tf.storage_id\nWHERE upload_date < #{date}\n"})
    @ResultType(value=TempFileBO.class)
    @Nonnull
    @ResultMap(value={"TempFileBOMap"})
    public List<TempFileBO> getOlderThan(@Param(value="date") Instant var1, RowBounds var2);

    @Update(value={"    UPDATE temp_file\n    SET video_teaser_id = #{videoTeaserId}\n    WHERE id = #{tempFileId}\n"})
    public void setVideoTeaser(TempFileId var1, VideoTeaserId var2);

    @Update(value={"    UPDATE temp_file\n    SET video_teaser_id = null\n    WHERE id = #{tempFileId}\n"})
    public void deleteVideoTeaser(TempFileId var1);
}

