/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.usergroup.impl;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.business.usergroup.UserGroupModificationService;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.common.usergroup.model.UserGroupId;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import de.justsoftware.drive.persistence.usergroup.UserGroupCreateModel;
import de.justsoftware.drive.persistence.usergroup.UserGroupDAO;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class UserGroupModificationServiceImpl
implements UserGroupModificationService {
    private final UserGroupDAO _userGroupDAO;
    private final SharesService _sharesService;
    private final TransactionSupport _transactionSupport;

    @Autowired
    public UserGroupModificationServiceImpl(UserGroupDAO userGroupDAO, SharesService sharesService, TransactionSupport transactionSupport) {
        this._userGroupDAO = userGroupDAO;
        this._sharesService = sharesService;
        this._transactionSupport = transactionSupport;
    }

    public void deleteUserGroup(UserGroupId userGroupId) {
        this._transactionSupport.doInTransaction(() -> {
            this._userGroupDAO.deleteGroup(userGroupId);
            this._sharesService.removeMemberships((Set)ImmutableSet.of((Object)userGroupId.asPermissionRole()));
        });
    }

    public void saveUserGroup(UserGroupId id, String name, TenantId tenantId, boolean isAllUsersGroup) {
        UserGroupCreateModel userGroupCreateModel = new UserGroupCreateModel(id).setName(name).setTenantId(tenantId).setIsAllUsersGroup(isAllUsersGroup);
        this._userGroupDAO.insertOrUpdate(userGroupCreateModel);
    }
}

