/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.person.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.drive.business.kafka.AbstractKafkaConsumer;
import de.justsoftware.drive.business.kafka.KafkaConfigurationProvider;
import de.justsoftware.drive.business.person.PersonModificationService;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PersonChangesConsumerImpl
extends AbstractKafkaConsumer<String, String> {
    private static final String TOPIC_NAME = "just.persons";
    private final PersonModificationService _personModificationService;

    @Autowired
    public PersonChangesConsumerImpl(KafkaConfigurationProvider kafkaConfigurationProvider, PersonModificationService personModificationService, TransactionSupport transactionSupport) {
        this(kafkaConfigurationProvider.stringConsumer("just.drive.PersonChangesConsumer.v2"), personModificationService, transactionSupport);
    }

    @VisibleForTesting
    PersonChangesConsumerImpl(@Nullable Consumer<String, String> consumer, PersonModificationService personModificationService, TransactionSupport transactionSupport) {
        super(consumer, transactionSupport, TOPIC_NAME);
        this._personModificationService = personModificationService;
    }

    protected void process(ConsumerRecords<String, String> records, java.util.function.Consumer<Runnable> afterCommitCallbackConsumer) {
        for (ConsumerRecord record : records) {
            JsonNode value = this.parseJson((String)record.value());
            if (value == null || !value.isObject()) continue;
            this._personModificationService.savePerson(new PersonId(Long.parseLong(value.findPath("id").asText())), value.findPath("email").asText(), value.findPath("fullName").asText(), value.findPath("firstName").asText(), value.findPath("lastName").asText(), value.findPath("imageUrl").asText(), value.findPath("profileHash").asText(), value.findPath("active").asBoolean(), value.findPath("blocked").asBoolean(), value.findPath("deleted").asBoolean(), value.findPath("tenantId").asText());
        }
    }
}

