/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.share;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.accessrequest.model.AccessRequestBO;
import de.justsoftware.drive.common.authorization.model.SharePrivilege;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.shares.model.ShareBO;
import de.justsoftware.drive.rest.exceptions.UnknownResourceException;
import de.justsoftware.drive.rest.models.Person;
import de.justsoftware.drive.rest.models.Share;
import de.justsoftware.drive.rest.models.ShareDetails;
import de.justsoftware.drive.rest.models.SharePermission;
import de.justsoftware.permission.client.model.Role;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface SharesFrontendService {
    @Nonnull
    public ImmutableList<Share> convertShareBOs(Collection<ItemBO> var1);

    public ImmutableList<Share> convertShareBOs(Collection<ItemBO> var1, Set<ItemBO> var2);

    @Nonnull
    default public Share convertShareBO(ItemBO itemBo, boolean subscribed) {
        Optional share = this.convertShareBOs(Set.of(itemBo), subscribed ? Set.of(itemBo) : Set.of()).stream().findFirst();
        return (Share)share.orElseThrow(() -> new UnknownResourceException("Share " + String.valueOf(itemBo.getId()) + " not found"));
    }

    @Nonnull
    public ImmutableMap<Role, SharePrivilege> convertMembers(Map<String, SharePermission> var1);

    @Nonnull
    public ShareDetails convertShareBO(ShareBO var1);

    @Nonnull
    public ImmutableList<Person> getRequestingUsersFromAccessRequests(ImmutableSet<AccessRequestBO> var1);
}

