/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.transaction;

import de.justsoftware.drive.persistence.transaction.TransactionCallback;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@ParametersAreNonnullByDefault
@FunctionalInterface
public interface TransactionSupport {
    @Nonnull
    public <T> T doInTransaction(TransactionCallback<T> var1);

    default public void doInTransaction(Runnable action) {
        this.doInTransaction(() -> {
            action.run();
            return this;
        });
    }

    default public void doAfterTransaction(Runnable action) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            action.run();
        }
    }

    default public void flushBatchStatements() {
    }
}

