/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.VirusScanBo;
import de.justsoftware.drive.common.file.model.VirusScanStatus;
import de.justsoftware.drive.persistence.file.VirusScanDAO;
import de.justsoftware.drive.persistence.file.VirusScanMapper;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class VirusScanDAOImpl
implements VirusScanDAO {
    private final VirusScanMapper _virusScanMapper;

    @Autowired
    public VirusScanDAOImpl(VirusScanMapper virusScanMapper) {
        this._virusScanMapper = virusScanMapper;
    }

    public void addVirusScanRequest(StorageId storageId) {
        this._virusScanMapper.insertVirusScan(new VirusScanBo(storageId, VirusScanStatus.QUEUED, null));
    }

    public void setVirusScanResult(VirusScanBo virusScanBo) {
        this._virusScanMapper.setVirusScanResult(virusScanBo);
    }

    public VirusScanBo findVirusScanStatus(StorageId storageId) {
        return this._virusScanMapper.findVirusScanStatus(storageId);
    }

    public void deleteVirusScanStatus(Set<StorageId> storageId) {
        if (!storageId.isEmpty()) {
            this._virusScanMapper.deleteVirusScanStatus(storageId);
        }
    }
}

