/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.document;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.document.DocumentVersionCountDAO;
import de.justsoftware.drive.persistence.document.DocumentVersionCountMapper;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@ParametersAreNonnullByDefault
@Repository
public class DocumentVersionCountDAOImpl
implements DocumentVersionCountDAO {
    private final DAOSupport _daoSupport;
    private final DocumentVersionCountMapper _mapper;

    @Autowired
    public DocumentVersionCountDAOImpl(DAOSupport daoSupport, DocumentVersionCountMapper mapper) {
        this._daoSupport = daoSupport;
        this._mapper = mapper;
    }

    public void increment(Set<DocumentVersionId> items) {
        this._daoSupport.partition(items).noResult(arg_0 -> ((DocumentVersionCountMapper)this._mapper).increment(arg_0));
    }

    @Nonnull
    public ImmutableMap<DocumentVersionId, Integer> getCount(Set<DocumentVersionId> items) {
        ImmutableMap result = this._daoSupport.partition(items).asMap((arg_0, arg_1) -> ((DocumentVersionCountMapper)this._mapper).getCount(arg_0, arg_1));
        return (ImmutableMap)items.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), id -> (Integer)result.getOrDefault(id, (Object)0)));
    }

    @Nonnull
    public ImmutableMap<DocumentId, Integer> getCountForDocument(Set<DocumentId> documents) {
        ImmutableMap result = this._daoSupport.partition(documents).asMap((arg_0, arg_1) -> ((DocumentVersionCountMapper)this._mapper).getCountByDocument(arg_0, arg_1));
        return (ImmutableMap)documents.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), arg_0 -> DocumentVersionCountDAOImpl.lambda$getCountForDocument$1((Map)result, arg_0)));
    }

    private static /* synthetic */ Integer lambda$getCountForDocument$1(Map result, DocumentId id) {
        return result.getOrDefault(id, 0);
    }
}

