/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.mybatis.type;

import com.google.common.base.Strings;
import de.justsoftware.drive.mybatis.type.TypeHandlers;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;

@ParametersAreNonnullByDefault
@MappedJdbcTypes(value={JdbcType.VARCHAR, JdbcType.CHAR, JdbcType.LONGVARCHAR, JdbcType.NVARCHAR, JdbcType.NCHAR}, includeNullJdbcType=true)
public class StringBasedTypeHandler<T>
extends BaseTypeHandler<T> {
    private final Function<T, String> _toString;
    private final Function<String, T> _fromString;

    public StringBasedTypeHandler(Class<T> clz, Function<T, String> toString) {
        this(TypeHandlers.construct(clz, String.class), toString);
    }

    public StringBasedTypeHandler(Function<String, T> fromString, Function<T, String> toString) {
        this._fromString = fromString;
        this._toString = toString;
    }

    public final void setNonNullParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, (String)this._toString.apply(parameter));
    }

    public final T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return (T)this.convert(rs.getString(columnName));
    }

    @CheckForNull
    private T convert(@Nullable String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        return (T)this._fromString.apply(s);
    }

    public final T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return (T)this.convert(rs.getString(columnIndex));
    }

    public final T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return (T)this.convert(cs.getString(columnIndex));
    }
}

