/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.mybatis.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;

@ParametersAreNonnullByDefault
public final class ChunkedResultHandler<T>
implements ResultHandler<T> {
    private final ArrayList<T> _results;
    private final int _chunkSize;
    private final Consumer<List<T>> _consumer;
    private int _count = 0;

    public ChunkedResultHandler(int chunkSize, Consumer<List<T>> consumer) {
        this._chunkSize = chunkSize;
        this._consumer = consumer;
        this._results = new ArrayList(chunkSize);
    }

    public void handleResult(ResultContext<? extends T> resultContext) {
        this._results.add(resultContext.getResultObject());
        if (this._results.size() >= this._chunkSize) {
            this.consume();
        }
        ++this._count;
    }

    private void consume() {
        this._consumer.accept(Collections.unmodifiableList(this._results));
        this._results.clear();
    }

    public int finish() {
        this.consume();
        return this._count;
    }

    public int applyTo(Consumer<ResultHandler<T>> method) {
        method.accept((ResultHandler<ChunkedResultHandler>)this);
        return this.finish();
    }
}

