/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.tenant;

import de.justsoftware.drive.business.publiclinks.PublicLinkService;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.common.tenant.model.TenantId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@Component
public class KafkaTenantConsumer {
    private static final String TOPIC = "just.tenants";
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTenantConsumer.class);
    private final SharesService _sharesService;
    private final PublicLinkService _publicLinkService;

    KafkaTenantConsumer(SharesService sharesService, PublicLinkService publicLinkService) {
        this._sharesService = sharesService;
        this._publicLinkService = publicLinkService;
    }

    @KafkaListener(id="just.drive.tenantConsumer", topics={"just.tenants"}, containerFactory="tenantListenerContainerFactory")
    public void listen(@Nonnull @Header(value="kafka_receivedMessageKey") TenantId tenantId, @Payload(required=false) @Nullable String json) {
        if (json == null) {
            LOG.info("tenant {} deleted message received.", (Object)tenantId);
            this._sharesService.deleteAllShares(tenantId);
            this._publicLinkService.deleteAllForTenant(tenantId);
        } else {
            LOG.info("Skipping message because tenant: {} was not deleted.", (Object)tenantId);
        }
    }
}

