/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.shares.impl;

import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.business.shares.PermissionShareItemPublisher;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.permission.client.kafka.PermissionItemProducer;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class PermissionShareItemPublisherImpl
implements PermissionShareItemPublisher {
    private final ItemReadService _itemReadService;
    private final PermissionItemProducer _permissionItemProducer;

    @Autowired
    public PermissionShareItemPublisherImpl(ItemReadService itemReadService, PermissionItemProducer permissionItemProducer) {
        this._itemReadService = itemReadService;
        this._permissionItemProducer = permissionItemProducer;
    }

    public void publishAllShares() {
        this._permissionItemProducer.republish(ItemType.SHARE.name(), () -> this._itemReadService.forAllShares(arg_0 -> this.publishShare(arg_0)));
    }

    private void publishShare(ItemBO itemBO) {
        if (itemBO.isDeleted()) {
            this._permissionItemProducer.publishDeletedItem((String)itemBO.getId().getId());
        } else {
            this._permissionItemProducer.publishItem((String)itemBO.getId().getId(), Optional.ofNullable(itemBO.getTenantId()).map(tenantId -> tenantId.asPermissionRole().asString()), new String[0]);
        }
    }

    public void publishDeletedShare(ItemId shareId) {
        this._permissionItemProducer.publishDeletedItem((String)shareId.getId());
    }

    public void publishNewShare(ItemId shareId, TenantId tenantId) {
        this._permissionItemProducer.publishItem((String)shareId.getId(), Optional.of(tenantId.asPermissionRole().asString()), new String[0]);
    }
}

