/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search;

import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.search.shared.model.SearchableId;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SearchUtils {
    private SearchUtils() {
    }

    public static boolean isSearchable(@Nullable DocumentVersionBO documentVersion) {
        if (documentVersion == null) {
            return false;
        }
        ItemType.Searchability searchability = documentVersion.getItemId().getType().getSearchability();
        return (Boolean)documentVersion.accept((DocumentVersionBO.Visitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Nonnull
    public static DocumentId toDocumentId(SearchableId searchableId) {
        if (!"DRIVE_DOCUMENT".equals(searchableId.getType())) {
            throw new IllegalStateException("Type of SearchableId is not a documentId: " + searchableId.toCanonicalId());
        }
        return new DocumentId(UUID.fromString(searchableId.getValue()));
    }
}

