/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.document.util.FileMetaInfoUtil;
import de.justsoftware.drive.business.search.IndexerData;
import de.justsoftware.drive.business.search.SearchIndexDataService;
import de.justsoftware.drive.business.search.SearchIndexPublisher;
import de.justsoftware.drive.business.search.SearchUtils;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.common.authorization.model.Role;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.search.shared.DefaultSolrIndexDataLoader;
import de.justsoftware.search.shared.LoaderContext;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.GlobalAdditionalFields;
import de.justsoftware.search.shared.model.JustApp;
import de.justsoftware.search.shared.model.JustSocialContentAtomicUpdateSolrDocument;
import de.justsoftware.search.shared.model.JustSocialFullUpdateSolrDocument;
import de.justsoftware.search.shared.model.JustSocialMetadataAtomicUpdateSolrDocument;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SearchableId;
import de.justsoftware.search.shared.model.SolrIndexType;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class DriveSolrIndexDataLoader
extends DefaultSolrIndexDataLoader {
    private final SearchIndexDataService _searchIndexDataService;
    private final SharesService _sharesService;
    private final DocumentService _documentService;
    private final SearchIndexPublisher _searchIndexPublisher;

    public DriveSolrIndexDataLoader(SearchIndexDataService searchIndexDataService, SolrIndexQueue solrIndexQueue, SharesService sharesService, DocumentService documentService, SearchIndexPublisher searchIndexPublisher) {
        super(JustApp.DRIVE, "25.10.10-4781", solrIndexQueue);
        this._searchIndexDataService = searchIndexDataService;
        this._sharesService = sharesService;
        this._documentService = documentService;
        this._searchIndexPublisher = searchIndexPublisher;
    }

    public Map<SearchableId, JustSocialFullUpdateSolrDocument> loadFullData(List<SearchableId> ids, LoaderContext context) {
        IndexerData indexData = this.loadIndexerData(ids);
        Map<SearchableId, JustSocialFullUpdateSolrDocument> result = this.loadMetaData(ids, indexData).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((JustSocialMetadataAtomicUpdateSolrDocument)e.getValue()).toFullUpdateSolrDocument(null)));
        context.doAfterSendToSearchService(() -> result.values().forEach(document -> {
            DocumentId documentId = SearchUtils.toDocumentId((SearchableId)document.getId());
            DocumentVersionBO documentVersion = indexData.getCurrentDocumentVersion(documentId);
            if (documentVersion != null) {
                documentVersion.accept(file -> {
                    this._searchIndexPublisher.publishIndexContent(file.getDocumentId(), file.getStorageId(), file.getFileSize());
                    return this;
                }, folder -> this);
            }
        }));
        return result;
    }

    public Map<SearchableId, JustSocialMetadataAtomicUpdateSolrDocument> loadMetaData(List<SearchableId> ids, LoaderContext context) {
        IndexerData indexData = this.loadIndexerData(ids);
        return this.loadMetaData(ids, indexData);
    }

    public Map<SearchableId, JustSocialContentAtomicUpdateSolrDocument> loadContentData(List<SearchableId> ids, LoaderContext context) {
        return null;
    }

    @Transactional
    public void handleReindexForTypes(Set<? extends SearchType> types, @Nullable de.justsoftware.search.shared.model.TenantId tenantId) {
        super.handleReindexForTypes(types, tenantId);
    }

    @Transactional
    public Stream<SearchableId> getAllSearchableIdForType(SearchType type, @Nullable de.justsoftware.search.shared.model.TenantId tenantId) {
        if (SearchType.DRIVE_FILE != type) {
            return Stream.empty();
        }
        if (tenantId != null) {
            throw new UnsupportedOperationException("Retrieving DocumentIds depending on tenantId is not supported.");
        }
        return this._documentService.streamAllSearchableDocumentIds().map(documentId -> SearchableId.Companion.fromCanonicalId(documentId.toSearchId()));
    }

    @Nonnull
    private IndexerData loadIndexerData(List<SearchableId> ids) {
        ImmutableSetMultimap.Builder documents = ImmutableSetMultimap.builder();
        ids.forEach(id -> documents.put((Object)SearchUtils.toDocumentId((SearchableId)id), (Object)SolrIndexType.METADATA));
        return this._searchIndexDataService.getIndexData((SetMultimap)documents.build());
    }

    @Nonnull
    private Map<SearchableId, JustSocialMetadataAtomicUpdateSolrDocument> loadMetaData(List<SearchableId> ids, IndexerData indexData) {
        Set shareIds = ids.stream().map(id -> indexData.getCurrentDocumentVersion(SearchUtils.toDocumentId((SearchableId)id))).filter(version -> version != null && version.getItemId().getType().equals((Object)ItemType.SHARE)).map(DocumentVersionBO::getItemId).collect(Collectors.toSet());
        ImmutableMap rootFolderIds = this._sharesService.getRootFolderIds(shareIds);
        ImmutableMap.Builder result = ImmutableMap.builder();
        new HashSet<SearchableId>(ids).forEach(id -> {
            JustSocialMetadataAtomicUpdateSolrDocument solrDocument = DriveSolrIndexDataLoader.createMetadataAtomicUpdateSolrDocument((SearchableId)id, (ImmutableMap)rootFolderIds, (IndexerData)indexData);
            if (solrDocument != null) {
                result.put(id, (Object)solrDocument);
            }
        });
        return result.build();
    }

    @CheckForNull
    private static JustSocialMetadataAtomicUpdateSolrDocument createMetadataAtomicUpdateSolrDocument(SearchableId searchableId, ImmutableMap<ItemId, DocumentId> rootFolderIds, IndexerData indexData) {
        DocumentId documentId = SearchUtils.toDocumentId((SearchableId)searchableId);
        DocumentVersionBO documentVersion = indexData.getCurrentDocumentVersion(documentId);
        if (!SearchUtils.isSearchable((DocumentVersionBO)documentVersion)) {
            return null;
        }
        ItemId parentId = documentVersion.getItemId();
        boolean parentIsShare = parentId.getType().equals((Object)ItemType.SHARE);
        boolean isShare = documentVersion.isRoot() && parentIsShare;
        SearchableId searchableParentId = DriveSolrIndexDataLoader.toSearchableId((AbstractId)(parentIsShare ? (AbstractId)rootFolderIds.get((Object)parentId) : parentId));
        ItemBO parentItem = indexData.getItem(parentId);
        String name = DriveSolrIndexDataLoader.getName((DocumentVersionBO)documentVersion, (ItemBO)parentItem);
        SearchType searchType = isShare ? SearchType.DRIVE_SHARE : (SearchType)documentVersion.accept(file -> SearchType.DRIVE_FILE, folder -> SearchType.DRIVE_FOLDER);
        return new JustSocialMetadataAtomicUpdateSolrDocument(searchableId, name, DriveSolrIndexDataLoader.getApp((ItemId)parentId), searchType, documentVersion.getChangeDate(), DriveSolrIndexDataLoader.getPublicationDate((DocumentVersionBO)documentVersion, (IndexerData)indexData), isShare ? DriveSolrIndexDataLoader.getTenantId((ItemBO)parentItem) : null, isShare ? null : searchableParentId, false, isShare ? DriveSolrIndexDataLoader.getVisibleRoles((DocumentVersionBO)documentVersion, (IndexerData)indexData) : null, null, name, isShare ? null : searchableParentId, DriveSolrIndexDataLoader.getTags((DocumentVersionBO)documentVersion, (IndexerData)indexData), DriveSolrIndexDataLoader.getSearchableFields((DocumentVersionBO)documentVersion, (IndexerData)indexData), DriveSolrIndexDataLoader.getAdditionalFields((DocumentVersionBO)documentVersion, (boolean)isShare, (IndexerData)indexData));
    }

    @Nonnull
    private static Instant getPublicationDate(DocumentVersionBO documentVersion, IndexerData indexData) {
        ChangeBO firstPublicChange = indexData.getChange(documentVersion.getFirstPublicChange());
        return Optional.ofNullable(firstPublicChange != null ? firstPublicChange.getFirstPublishedDate() : null).orElseGet(() -> ((DocumentVersionBO)documentVersion).getChangeDate());
    }

    @Nonnull
    private static JustApp getApp(ItemId parentId) {
        if (ItemType.POST.equals((Object)parentId.getType())) {
            return JustApp.NEWS;
        }
        return JustApp.DRIVE;
    }

    @Nonnull
    private static String getName(DocumentVersionBO documentVersion, @Nullable ItemBO item) {
        if (documentVersion.isRoot() && item != null) {
            return item.getName();
        }
        return documentVersion.getName();
    }

    @Nonnull
    private static Set<String> getVisibleRoles(DocumentVersionBO documentVersion, IndexerData indexData) {
        ItemBO item = indexData.getItem(documentVersion.getItemId());
        if (item == null || item.isDeleted()) {
            return ImmutableSet.of();
        }
        ImmutableSet v = indexData.getVisibilities(documentVersion.getItemId(), StaticAction.DOCUMENT_READ);
        return v.stream().map(Role::getRoleString).collect(Collectors.toSet());
    }

    @CheckForNull
    private static de.justsoftware.search.shared.model.TenantId getTenantId(@Nullable ItemBO parentItem) {
        if (parentItem != null && !parentItem.isDeleted()) {
            TenantId tenantId = parentItem.getTenantId();
            if (tenantId == null) {
                return null;
            }
            return new de.justsoftware.search.shared.model.TenantId((UUID)tenantId.getId());
        }
        return null;
    }

    @Nonnull
    private static List<String> getTags(DocumentVersionBO documentVersion, IndexerData indexData) {
        DocumentBO metadata = indexData.getDocument(documentVersion.getDocumentId());
        if (metadata == null) {
            return ImmutableList.of();
        }
        return Lists.newArrayList((Iterable)Splitter.on((char)',').split((CharSequence)metadata.getTags()));
    }

    @Nonnull
    private static Map<String, List<String>> getSearchableFields(DocumentVersionBO documentVersion, IndexerData indexData) {
        DocumentBO metadata = indexData.getDocument(documentVersion.getDocumentId());
        if (metadata == null) {
            return Map.of();
        }
        return Map.of("description", ImmutableList.of((Object)metadata.getDescription()));
    }

    @Nonnull
    private static Map<String, List<String>> getAdditionalFields(DocumentVersionBO documentVersion, boolean isShare, IndexerData indexData) {
        HashMap result = (HashMap)documentVersion.accept(file -> {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            map.put(GlobalAdditionalFields.FILE_SIZE.name(), List.of(String.valueOf(file.getFileSize())));
            map.put(GlobalAdditionalFields.MIME_TYPE.name(), List.of(file.getMimeType()));
            map.put(GlobalAdditionalFields.FILE_TYPE.name(), List.of(FileMetaInfoUtil.getFileType((String)file.getMimeType()).toSearchDriveFileType().toString()));
            return map;
        }, folder -> new HashMap());
        if (isShare) {
            SearchableId searchableId = DriveSolrIndexDataLoader.toSearchableId((AbstractId)documentVersion.getItemId());
            result.put("share_id", searchableId != null ? List.of(searchableId.toString()) : null);
        }
        DocumentVersionId documentVersionId = documentVersion.getId();
        List parentFolders = indexData.getPath(documentVersionId).stream().filter(pathId -> !pathId.equals((Object)documentVersionId)).map(arg_0 -> ((IndexerData)indexData).getFolder(arg_0)).filter(Objects::nonNull).map(DocumentVersionBO::getDocumentId).map(DocumentId::toSearchId).collect(Collectors.toList());
        result.put("drive_parent_folder_id", parentFolders);
        return result;
    }

    @CheckForNull
    private static SearchableId toSearchableId(@Nullable AbstractId<?> id) {
        if (id instanceof ItemId) {
            ItemId itemId = (ItemId)id;
            return new SearchableId(itemId.getValue(), itemId.getType().name());
        }
        if (id instanceof DocumentId) {
            return SearchableId.Companion.fromCanonicalId(((DocumentId)id).toSearchId());
        }
        return null;
    }
}

