/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import de.justsoftware.drive.business.exception.NoPreviewPossibleBusinessException;
import de.justsoftware.drive.business.exception.ResourceNotYetAvailableBusinessException;
import de.justsoftware.drive.business.exception.ResourceUnavailableException;
import de.justsoftware.drive.business.exception.UnknownResourceBusinessException;
import de.justsoftware.drive.business.file.FilePreviewService;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.file.TempFileService;
import de.justsoftware.drive.business.file.VideoTeaserService;
import de.justsoftware.drive.business.preview.ImagePreviewOptions;
import de.justsoftware.drive.business.thumbor.ThumborService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FilePreviewByteSource;
import de.justsoftware.drive.common.file.model.FilePreviewInfoBO;
import de.justsoftware.drive.common.file.model.FilePreviewStatus;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.PreviewId;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.TempFileBO;
import de.justsoftware.drive.common.file.model.TempFileId;
import de.justsoftware.drive.filepersistence.file.FileStorageDAO;
import de.justsoftware.drive.persistence.file.FileVersionPreviewCreateModel;
import de.justsoftware.drive.persistence.file.FileVersionPreviewDAO;
import de.justsoftware.jdoc.rest.exceptions.DocumentRepositoryAPIException;
import de.justsoftware.jdoc.rest.model.ExternalDocumentId;
import de.justsoftware.jdoc.rest.model.ExternalDocumentType;
import de.justsoftware.jdoc.rest.model.ExternalTypedInputStream;
import de.justsoftware.jdoc.rest.service.client.DocumentManager;
import de.justsoftware.judoclient.conversiontask.ConversionTaskClient;
import de.justsoftware.judoclient.model.ConversionTask;
import de.justsoftware.judoclient.model.Keyable;
import io.micrometer.observation.annotation.Observed;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
@Observed
public class FilePreviewServiceImpl
implements FilePreviewService {
    private static final Logger LOG = LoggerFactory.getLogger(FilePreviewServiceImpl.class);
    private static final String VIDEO_COVER_SUFFIX = ".converted_cover.png";
    private static final String PREVIEW_NOT_FOUND = "No preview found.";
    private static final String NO_PREVIEW_AVAILABLE = "No preview available.";
    private static final String NO_PREVIEW_AVAILABLE_YET = "No preview available yet. Try again later.";
    private static final String NO_FILE_VERSION_FOUND = "No file version found.";
    private final DocumentManager _documentManager;
    private final FileVersionPreviewDAO _previewDAO;
    private final FileStorageDAO _fileStorageDAO;
    private final ConversionTaskClient _conversionTaskClient;
    private final ThumborService _thumborService;
    private final FileService _fileService;
    private final String _judoUrl;
    private final TempFileService _tempFileService;
    private final VideoTeaserService _videoTeaserService;
    private final List<String> _unsupportedFileTypes;

    @Autowired
    public FilePreviewServiceImpl(DocumentManager docManager, FileVersionPreviewDAO previewDAO, FileStorageDAO fileStorageDAO, ConversionTaskClient conversionTaskClient, ThumborService thumborService, FileService fileService, @Value(value="${just.drive.judo.url}") String judoUrl, TempFileService tempFileService, VideoTeaserService videoTeaserService, @Value(value="${just.drive.file.preview.unsupported.extensions}") List<String> unsupportedFileTypes) {
        this._documentManager = docManager;
        this._previewDAO = previewDAO;
        this._fileStorageDAO = fileStorageDAO;
        this._conversionTaskClient = conversionTaskClient;
        this._thumborService = thumborService;
        this._fileService = fileService;
        this._judoUrl = judoUrl;
        this._tempFileService = tempFileService;
        this._videoTeaserService = videoTeaserService;
        this._unsupportedFileTypes = unsupportedFileTypes;
    }

    private void dispatchFilePreviewRequest(StorageId storageId, String mimeType) {
        if (!this._previewDAO.getPreviewInfos(Set.of(storageId)).isEmpty()) {
            LOG.debug("Skip creating a preview. StorageId {} already has a preview", (Object)storageId);
            return;
        }
        String fileType = ((String)storageId.getId()).substring(((String)storageId.getId()).lastIndexOf(46) + 1);
        if (mimeType.startsWith("audio/") || this._unsupportedFileTypes.contains(fileType)) {
            this.savePreviewInfoToDatabase(FilePreviewInfoBO.fromUnsupported((StorageId)storageId));
            return;
        }
        if (mimeType.startsWith("image/")) {
            this.savePreviewInfoToDatabase(FilePreviewInfoBO.fromPresent((StorageId)storageId));
            return;
        }
        PreviewId previewId = PreviewId.random();
        String storageFileUrl = this._fileStorageDAO.getUrl(storageId);
        ConversionTask conversion = new ConversionTask((String)previewId.getId(), storageFileUrl, mimeType);
        this._conversionTaskClient.dispatch((Keyable)conversion);
        LOG.debug("Sent conversion task for {} to Kafka.", (Object)previewId);
        this.savePreviewInfoToDatabase(FilePreviewInfoBO.fromQueued((StorageId)storageId, (PreviewId)previewId));
    }

    public void requestFilePreview(List<FileVersionBO> files) {
        ((ImmutableMap)files.stream().collect(ImmutableMap.toImmutableMap(FileVersionBO::getStorageId, FileVersionBO::getMimeType, (first, second) -> first))).forEach((arg_0, arg_1) -> this.dispatchFilePreviewRequest(arg_0, arg_1));
    }

    public FilePreviewByteSource getFilePreview(DocumentVersionId fileVersion, String resource) {
        PreviewId previewId = (PreviewId)this._previewDAO.getPreviewIdByFileVersionId((Set)ImmutableSet.of((Object)fileVersion)).get((Object)fileVersion);
        if (previewId == null) {
            return null;
        }
        try {
            ExternalTypedInputStream documentResource = this._documentManager.getDocumentResource(new ExternalDocumentId((String)previewId.getId()), ExternalDocumentType.HTML, resource);
            return new FilePreviewByteSource(documentResource.getSize(), documentResource.getContentType(), (InputStream)documentResource);
        }
        catch (DocumentRepositoryAPIException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void savePreviewInfoToDatabase(FilePreviewInfoBO previewInfoBO) {
        this._previewDAO.create(FileVersionPreviewCreateModel.from((FilePreviewInfoBO)previewInfoBO));
    }

    public ImmutableMap<StorageId, FilePreviewInfoBO> getFilePreviewInfos(Set<StorageId> storageIds) {
        return this._previewDAO.getPreviewInfos(storageIds);
    }

    public ImmutableMap<PreviewId, FilePreviewInfoBO> getPreviewInfosByPreviewId(Set<PreviewId> previewIds) {
        return this._previewDAO.getPreviewInfosByPreviewId(previewIds);
    }

    public void updateStatus(FilePreviewInfoBO filePreview, FilePreviewStatus status) {
        this._previewDAO.update(FileVersionPreviewCreateModel.from((FilePreviewInfoBO)filePreview).setPreviewStatus(status));
    }

    @Nonnull
    public FilePreviewByteSource getImage(DocumentVersionId id, ImagePreviewOptions previewOptions) throws IOException {
        FileVersionBO fileVersion = this._fileService.getSingleVersionById(id);
        if (fileVersion == null) {
            throw new ResourceUnavailableException(NO_FILE_VERSION_FOUND);
        }
        String previewUrl = this.useVideoPreviewUrlOrStorageServerUrl(fileVersion);
        MediaType mimeType = this.usePNGMimeTypeForVideoOrOriginal(fileVersion);
        return this._thumborService.apply(mimeType, previewUrl, previewOptions);
    }

    public FilePreviewByteSource getImage(DocumentId documentId, ImagePreviewOptions previewOptions) throws IOException {
        FileVersionBO fileVersion = this._fileService.getLastFileVersion(documentId);
        if (fileVersion == null) {
            throw new ResourceUnavailableException(NO_FILE_VERSION_FOUND);
        }
        String previewUrl = this.useVideoPreviewUrlOrStorageServerUrl(fileVersion);
        MediaType mimeType = this.usePNGMimeTypeForVideoOrOriginal(fileVersion);
        return this._thumborService.apply(mimeType, previewUrl, previewOptions);
    }

    public FilePreviewByteSource getImage(TempFileId id, ImagePreviewOptions options) throws IOException {
        TempFileBO tempFileBO = (TempFileBO)this._tempFileService.getTempFiles(Set.of(id)).get((Object)id);
        if (tempFileBO == null) {
            throw new NoPreviewPossibleBusinessException("No temporary file found.");
        }
        if (!ThumborService.isMediaTypeSupported((String)tempFileBO.getMimeType())) {
            throw new NoPreviewPossibleBusinessException("Unsupported mime type.");
        }
        MediaType mimeType = MediaType.parse((String)tempFileBO.getMimeType());
        String previewUrl = this._fileStorageDAO.getUrl(tempFileBO.getStorageId());
        return this._thumborService.apply(mimeType, previewUrl, options);
    }

    public String getConvertedVideoUrl(DocumentVersionId fileVersion) {
        PreviewId previewId = this.checkVideoPreviewIsPresent(fileVersion);
        return this.getVideoPreviewUrl(previewId, ".converted.mp4");
    }

    @Nonnull
    @VisibleForTesting
    PreviewId checkVideoPreviewIsPresent(DocumentVersionId fileVersion) {
        FilePreviewInfoBO previewInfo = this.returnPreviewIfAvailableAtOnePoint(fileVersion);
        FilePreviewStatus previewStatus = previewInfo.getPreviewStatus();
        if (FilePreviewStatus.PRESENT.equals((Object)previewStatus)) {
            return (PreviewId)UnknownResourceBusinessException.checkNotNull((Object)previewInfo.getPreviewId(), (String)PREVIEW_NOT_FOUND);
        }
        int retryAfter = 5;
        if (FilePreviewStatus.QUEUED.equals((Object)previewStatus)) {
            retryAfter = 10;
        }
        throw new ResourceNotYetAvailableBusinessException(NO_PREVIEW_AVAILABLE_YET, retryAfter);
    }

    @Nonnull
    private FilePreviewInfoBO returnPreviewIfAvailableAtOnePoint(DocumentVersionId versionId) {
        FileVersionBO fileVersion = this._fileService.getSingleVersionById(versionId);
        if (fileVersion == null) {
            throw new ResourceUnavailableException(PREVIEW_NOT_FOUND);
        }
        StorageId storageId = fileVersion.getStorageId();
        FilePreviewInfoBO preview = (FilePreviewInfoBO)this._previewDAO.getPreviewInfos((Set)ImmutableSet.of((Object)storageId)).get((Object)storageId);
        if (preview == null) {
            this.requestFilePreview((List)ImmutableList.of((Object)fileVersion));
            preview = (FilePreviewInfoBO)this._previewDAO.getPreviewInfos((Set)ImmutableSet.of((Object)storageId)).get((Object)storageId);
            UnknownResourceBusinessException.checkNotNull((Object)preview, (String)PREVIEW_NOT_FOUND);
        }
        if (FilePreviewStatus.ERRONEOUS_STATUS.contains(preview.getPreviewStatus())) {
            throw new NoPreviewPossibleBusinessException(NO_PREVIEW_AVAILABLE);
        }
        return preview;
    }

    public void checkPreviewWillBeAvailableAtOnePoint(DocumentVersionId fileVersion) throws ResourceNotYetAvailableBusinessException {
        this.returnPreviewIfAvailableAtOnePoint(fileVersion);
    }

    @Nonnull
    private String getVideoPreviewUrl(PreviewId previewId, String suffix) {
        return this._judoUrl + "/conversions/" + (String)previewId.getId() + suffix;
    }

    private boolean isVideo(FileVersionBO fileVersion) {
        return fileVersion.getMimeType().startsWith("video/");
    }

    @Nonnull
    private String useVideoPreviewUrlOrStorageServerUrl(FileVersionBO fileVersion) {
        if (this.isVideo(fileVersion)) {
            if (fileVersion.getVideoTeaserId() != null) {
                return this._videoTeaserService.getTeaserStorageUrl(fileVersion.getVideoTeaserId());
            }
            try {
                PreviewId previewId = this.checkVideoPreviewIsPresent(fileVersion.getId());
                return this.getVideoPreviewUrl(previewId, VIDEO_COVER_SUFFIX);
            }
            catch (UnknownResourceBusinessException e) {
                LOG.error("Can't load preview information for video file with file version id <{}>.", (Object)fileVersion.getId());
                throw new NoPreviewPossibleBusinessException(NO_PREVIEW_AVAILABLE);
            }
        }
        return this._fileService.getFileStorageUrl(fileVersion);
    }

    @Nonnull
    private MediaType usePNGMimeTypeForVideoOrOriginal(FileVersionBO fileVersion) {
        return this.isVideo(fileVersion) ? MediaType.PNG : MediaType.parse((String)fileVersion.getMimeType());
    }
}

