/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.business.exception.ResourceNotYetAvailableBusinessException;
import de.justsoftware.drive.business.preview.ImagePreviewOptions;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FilePreviewByteSource;
import de.justsoftware.drive.common.file.model.FilePreviewInfoBO;
import de.justsoftware.drive.common.file.model.FilePreviewStatus;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.PreviewId;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.TempFileId;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface FilePreviewService {
    @CheckForNull
    public FilePreviewByteSource getFilePreview(DocumentVersionId var1, String var2);

    @Nonnull
    public ImmutableMap<StorageId, FilePreviewInfoBO> getFilePreviewInfos(Set<StorageId> var1);

    public void requestFilePreview(List<FileVersionBO> var1);

    @Nonnull
    public ImmutableMap<PreviewId, FilePreviewInfoBO> getPreviewInfosByPreviewId(Set<PreviewId> var1);

    public void updateStatus(FilePreviewInfoBO var1, FilePreviewStatus var2);

    @Nonnull
    public FilePreviewByteSource getImage(DocumentId var1, ImagePreviewOptions var2) throws IOException;

    @Nonnull
    public FilePreviewByteSource getImage(DocumentVersionId var1, ImagePreviewOptions var2) throws IOException;

    @Nonnull
    public FilePreviewByteSource getImage(TempFileId var1, ImagePreviewOptions var2) throws IOException;

    @Nonnull
    public String getConvertedVideoUrl(DocumentVersionId var1);

    public void checkPreviewWillBeAvailableAtOnePoint(DocumentVersionId var1) throws ResourceNotYetAvailableBusinessException;
}

