/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.util;

import de.justsoftware.justdocumentz.util.FileUtils;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0006H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/justdocumentz/util/ConditionalDeleteVisitor;", "Ljava/nio/file/SimpleFileVisitor;", "Ljava/nio/file/Path;", "rootPath", "predicate", "Lkotlin/Function2;", "Ljava/nio/file/attribute/BasicFileAttributes;", "", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function2;)V", "deletedCount", "", "getDeletedCount", "()J", "setDeletedCount", "(J)V", "logger", "Lorg/slf4j/Logger;", "postVisitDirectory", "Ljava/nio/file/FileVisitResult;", "dir", "exc", "Ljava/io/IOException;", "visitFile", "file", "attrs", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\nde/justsoftware/justdocumentz/util/ConditionalDeleteVisitor\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n9#2:93\n1#3:94\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\nde/justsoftware/justdocumentz/util/ConditionalDeleteVisitor\n*L\n40#1:93\n*E\n"})
public final class ConditionalDeleteVisitor
extends SimpleFileVisitor<Path> {
    @NotNull
    private final Path rootPath;
    @NotNull
    private final Function2<Path, BasicFileAttributes, Boolean> predicate;
    private long deletedCount;
    @NotNull
    private final Logger logger;

    public ConditionalDeleteVisitor(@NotNull Path rootPath, @NotNull Function2<? super Path, ? super BasicFileAttributes, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        this.rootPath = rootPath;
        this.predicate = predicate;
        ConditionalDeleteVisitor $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(ConditionalDeleteVisitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public final long getDeletedCount() {
        return this.deletedCount;
    }

    public final void setDeletedCount(long l) {
        this.deletedCount = l;
    }

    @Override
    @NotNull
    public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        if (((Boolean)this.predicate.invoke((Object)file, (Object)attrs)).booleanValue() && FileUtils.INSTANCE.deleteFile(file)) {
            long l = this.deletedCount;
            this.deletedCount = l + 1L;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
        block4: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            if (Intrinsics.areEqual((Object)dir, (Object)this.rootPath) || !FileUtils.INSTANCE.isDirectoryEmpty(dir)) break block4;
            Object object2 = this;
            try {
                ConditionalDeleteVisitor $this$postVisitDirectory_u24lambda_u240 = object2;
                boolean bl = false;
                BasicFileAttributes attrs = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]);
                Function2 function2 = $this$postVisitDirectory_u24lambda_u240.predicate;
                Intrinsics.checkNotNull((Object)attrs);
                if (((Boolean)function2.invoke((Object)dir, (Object)attrs)).booleanValue() && FileUtils.INSTANCE.deleteFile(dir)) {
                    long l = $this$postVisitDirectory_u24lambda_u240.deletedCount;
                    $this$postVisitDirectory_u24lambda_u240.deletedCount = l + 1L;
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object e = object = throwable;
                boolean bl = false;
                this.logger.error("Error processing directory: " + dir, (Throwable)e);
            }
        }
        return FileVisitResult.CONTINUE;
    }
}

