/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions.document;

import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.conversions.UnsupportedConversionException;
import de.justsoftware.justdocumentz.conversions.document.Pdf2IFrameConversionService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J6\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0012J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\fH\u0012J\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bH\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/justdocumentz/conversions/document/Pdf2IFrameConversionService;", "", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "judoConfig", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/config/JudoConfig;)V", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "pageLimit", "", "buildIframe", "", "Ljava/nio/file/Path;", "imageFiles", "tempDir", "originalPageCount", "title", "", "convert", "pdfFile", "convertToImages", "document", "Lorg/apache/pdfbox/pdmodel/PDDocument;", "generateIframeHtml", "fileNames", "Companion", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nDocumentConversionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentConversionService.kt\nde/justsoftware/justdocumentz/conversions/document/Pdf2IFrameConversionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n1#2:310\n1855#3,2:311\n1549#3:313\n1620#3,3:314\n1549#3:317\n1620#3,3:318\n*S KotlinDebug\n*F\n+ 1 DocumentConversionService.kt\nde/justsoftware/justdocumentz/conversions/document/Pdf2IFrameConversionService\n*L\n196#1:311,2\n203#1:313\n203#1:314,3\n233#1:317\n233#1:318,3\n*E\n"})
public class Pdf2IFrameConversionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final JudoConfig judoConfig;
    private final int pageLimit;
    @NotNull
    private static final Path endOfPreviewResource;

    /*
     * WARNING - void declaration
     */
    public Pdf2IFrameConversionService(@NotNull JudoConfig config, @NotNull JudoConfig judoConfig) {
        void it;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)judoConfig, (String)"judoConfig");
        this.config = config;
        this.judoConfig = judoConfig;
        Integer n = this.getConfig().getConverter().getPageLimit();
        int n2 = ((Number)n).intValue();
        Pdf2IFrameConversionService pdf2IFrameConversionService = this;
        boolean bl = false;
        boolean bl2 = it > 0;
        Integer n3 = bl2 ? n : null;
        pdf2IFrameConversionService.pageLimit = n3 != null ? n3 : Integer.MAX_VALUE;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Path> convert(@NotNull Path pdfFile, @NotNull Path tempDir) {
        List list;
        Intrinsics.checkNotNullParameter((Object)pdfFile, (String)"pdfFile");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Closeable closeable = (Closeable)Loader.loadPDF((File)pdfFile.toFile());
        Throwable throwable = null;
        try {
            PDDocument document = (PDDocument)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)document);
            List imageFiles = this.convertToImages(document, tempDir);
            list = this.buildIframe(imageFiles, tempDir, document.getNumberOfPages(), document.getDocumentInformation().getTitle());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<Path> convertToImages(PDDocument document, Path tempDir) {
        void $this$mapTo$iv$iv;
        PDFRenderer renderer = new PDFRenderer(document);
        IntRange pageRange = RangesKt.until((int)0, (int)RangesKt.coerceAtMost((int)document.getNumberOfPages(), (int)this.pageLimit));
        Iterable $this$forEach$iv = (Iterable)pageRange;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            int element$iv;
            int pageIndex = element$iv = ((IntIterator)object).nextInt();
            boolean bl = false;
            PDPage page = document.getPage(pageIndex);
            if (!(page.getCropBox().getWidth() * page.getCropBox().getHeight() > (float)this.judoConfig.getConverter().getMaxPdfPx())) continue;
            throw new UnsupportedConversionException("PDF page exceeds configured maximum size in pixels");
        }
        Iterable $this$map$iv = (Iterable)pageRange;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void pageIndex;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path imagePath = tempDir.resolve("bg-" + (int)pageIndex + ".jpg");
            OutputStream outputStream = Files.newOutputStream(imagePath, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            int n2 = 8192;
            closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n2);
            Throwable throwable = null;
            try {
                BufferedOutputStream outStream = (BufferedOutputStream)closeable;
                boolean bl2 = false;
                BufferedImage pageImage = renderer.renderImageWithDPI((int)pageIndex, 96.0f);
                boolean bl3 = ImageIO.write((RenderedImage)pageImage, "jpg", outStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            collection.add(imagePath);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<Path> buildIframe(List<? extends Path> imageFiles, Path tempDir, int originalPageCount, String title) {
        List list;
        block5: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$buildIframe_u24lambda_u247;
            String string;
            Path endOfPreviewPath;
            Iterable<Path> it;
            if (originalPageCount > this.pageLimit) {
                Path path;
                it = path = tempDir.resolve("end_of_preview.png");
                boolean bl = false;
                Files.copy(endOfPreviewResource, it, new CopyOption[0]);
                v0 = path;
            } else {
                v0 = endOfPreviewPath = null;
            }
            if ((string = title) == null) {
                string = "";
            }
            Iterable<Path> bl = it = CollectionsKt.createListBuilder();
            String string2 = string;
            Pdf2IFrameConversionService pdf2IFrameConversionService = this;
            boolean $i$a$-buildList-Pdf2IFrameConversionService$buildIframe$previewHtml$22 = false;
            $this$buildIframe_u24lambda_u247.addAll((Collection)imageFiles);
            Path path = endOfPreviewPath;
            if (path != null) {
                Path it2 = path;
                boolean bl2 = false;
                $this$buildIframe_u24lambda_u247.add(it2);
            }
            Object object = Unit.INSTANCE;
            it = CollectionsKt.build((List)it);
            boolean $i$f$map = false;
            void $i$a$-buildList-Pdf2IFrameConversionService$buildIframe$previewHtml$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                Path path2 = (Path)item$iv$iv;
                object = destination$iv$iv;
                boolean bl3 = false;
                object.add(((Object)it3.getFileName()).toString());
            }
            object = (List)destination$iv$iv;
            String previewHtml = pdf2IFrameConversionService.generateIframeHtml(string2, (List)object);
            Path htmlPath = tempDir.resolve("index.html");
            Intrinsics.checkNotNull((Object)htmlPath);
            PathsKt.writeText((Path)htmlPath, (CharSequence)previewHtml, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
            List $this$buildIframe_u24lambda_u2410 = list = CollectionsKt.createListBuilder();
            boolean bl4 = false;
            $this$buildIframe_u24lambda_u2410.add(htmlPath);
            $this$buildIframe_u24lambda_u2410.addAll((Collection)imageFiles);
            Path path3 = endOfPreviewPath;
            if (path3 == null) break block5;
            Path it4 = path3;
            boolean bl5 = false;
            $this$buildIframe_u24lambda_u2410.add(it4);
        }
        return CollectionsKt.build((List)list);
    }

    private String generateIframeHtml(String title, List<String> fileNames) {
        return StringsKt.trimIndent((String)("\n            <!DOCTYPE html>\n            <html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"\" xml:lang=\"\">\n                <head>\n                    <title>" + title + "</title>\n                    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n                    <style type=\"text/css\">\n                        html, body {\n                            height: 100%;\n                            width: 100%;\n                        }\n\n                        .siteStyle {\n                            background-color: transparent;\n                            margin: 0;\n                        }\n\n                        .judo-wrapper {\n                            height: 100%;\n                            width: 100%;\n                            overflow: auto;\n                        }\n\n                        .pageStyle {\n                            margin: auto;\n                            padding: 5px 5px 5px 5px;\n                            text-align: center;\n                        }\n\n                        .imageStyle {\n                            margin: 0 auto;\n                            max-width: 100%;\n                            display: block;\n                        }\n                    </style>\n                    <script>\n                        function init() {\n                            const wrapperElement = document.querySelector(\".judo-wrapper\");\n                            wrapperElement.addEventListener(\"click\", evt => {\n                                if (evt.target === wrapperElement) {\n                                    parent.postMessage(\"outerContentClicked\", parent.location.origin);\n                                }\n                            });\n                        }\n                    </script>\n                </head>\n                <body onload=\"init();\" class=\"siteStyle\">\n                    <div class=\"judo-wrapper\">\n                        " + CollectionsKt.joinToString$default((Iterable)fileNames, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)generateIframeHtml.1.INSTANCE), (int)30, null) + "\n                    </div>\n                </body>\n            </html>\n        "));
    }

    public static final /* synthetic */ Path access$getEndOfPreviewResource$cp() {
        return endOfPreviewResource;
    }

    static {
        URL uRL = Companion.getClass().getClassLoader().getResource("assets/end_of_preview.png");
        if (uRL == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        URI uRI = uRL.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        Path path = Paths.get(uRI);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        endOfPreviewResource = path;
    }
}

