/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions;

import de.justsoftware.justdocumentz.conversions.ConversionStatus;
import de.justsoftware.justdocumentz.events.ConversionStatusChangeEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0012R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/justdocumentz/conversions/ConversionStatusPublisher;", "", "kafkaTemplate", "Lorg/springframework/kafka/core/KafkaTemplate;", "", "(Lorg/springframework/kafka/core/KafkaTemplate;)V", "getKafkaTemplate", "()Lorg/springframework/kafka/core/KafkaTemplate;", "onConversionStatusChange", "", "event", "Lde/justsoftware/justdocumentz/events/ConversionStatusChangeEvent;", "publishStatus", "conversionStatus", "Lde/justsoftware/justdocumentz/conversions/ConversionStatus;", "just-documentz"})
public class ConversionStatusPublisher {
    @NotNull
    private final KafkaTemplate<String, Object> kafkaTemplate;

    public ConversionStatusPublisher(@NotNull KafkaTemplate<String, Object> kafkaTemplate) {
        Intrinsics.checkNotNullParameter(kafkaTemplate, (String)"kafkaTemplate");
        this.kafkaTemplate = kafkaTemplate;
    }

    @NotNull
    public KafkaTemplate<String, Object> getKafkaTemplate() {
        return this.kafkaTemplate;
    }

    private void publishStatus(ConversionStatus conversionStatus) {
        this.getKafkaTemplate().send(new ProducerRecord("just.documents.conversion.status", (Object)("CONVERSION_STATUS," + conversionStatus.getId()), (Object)conversionStatus));
    }

    @EventListener(value={ConversionStatusChangeEvent.class})
    public void onConversionStatusChange(@NotNull ConversionStatusChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.publishStatus(new ConversionStatus(event.getTask().getId(), event.getStatus()));
    }
}

