/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.controller;

import de.justsoftware.justdocumentz.util.StoragePaths;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/justdocumentz/controller/DocumentViewService;", "", "storagePaths", "Lde/justsoftware/justdocumentz/util/StoragePaths;", "(Lde/justsoftware/justdocumentz/util/StoragePaths;)V", "getStoragePaths", "()Lde/justsoftware/justdocumentz/util/StoragePaths;", "getConvertedVideo", "Lorg/springframework/core/io/Resource;", "documentId", "Ljava/util/UUID;", "getCoverImage", "getDocumentPreviewResource", "contentResource", "", "just-documentz"})
public class DocumentViewService {
    @NotNull
    private final StoragePaths storagePaths;

    public DocumentViewService(@NotNull StoragePaths storagePaths) {
        Intrinsics.checkNotNullParameter((Object)storagePaths, (String)"storagePaths");
        this.storagePaths = storagePaths;
    }

    @NotNull
    public StoragePaths getStoragePaths() {
        return this.storagePaths;
    }

    @NotNull
    public Resource getDocumentPreviewResource(@NotNull UUID documentId, @NotNull String contentResource) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)contentResource, (String)"contentResource");
        StoragePaths storagePaths = this.getStoragePaths();
        String string = documentId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return (Resource)new FileSystemResource(storagePaths.documentPreviewFile(string, contentResource));
    }

    @NotNull
    public Resource getConvertedVideo(@NotNull UUID documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        StoragePaths storagePaths = this.getStoragePaths();
        String string = documentId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return (Resource)new FileSystemResource(storagePaths.convertedVideo(string));
    }

    @NotNull
    public Resource getCoverImage(@NotNull UUID documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        StoragePaths storagePaths = this.getStoragePaths();
        String string = documentId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return (Resource)new FileSystemResource(storagePaths.coverImage(string));
    }
}

