/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.judo.kafka;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.KafkaAdmin;

/*
 * Exception performing whole class analysis ignored.
 */
@Profile(value={"!DocumentServiceTest"})
@Configuration
@ParametersAreNonnullByDefault
public class KafkaTopicConfiguration {
    public static final String CONVERSION_TASK_TOPIC_BEAN = "conversionTaskTopic";
    private static final String SEVEN_DAYS_IN_MS = "604800000";
    private static final ImmutableMap<String, String> DEFAULT_TOPIC_CONFIG = ImmutableMap.of((Object)"delete.retention.ms", (Object)"604800000", (Object)"segment.ms", (Object)"604800000", (Object)"cleanup.policy", (Object)"delete");

    @CheckForNull
    @Bean
    public KafkaAdmin admin(@Value(value="${spring.kafka.bootstrapServers}") String bootstrapServers) {
        ImmutableMap configs = ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServers);
        KafkaAdmin kafkaAdmin = new KafkaAdmin((Map)configs);
        kafkaAdmin.setFatalIfBrokerNotAvailable(true);
        return kafkaAdmin;
    }

    @Nonnull
    private static NewTopic topicFactory(String topicName) {
        NewTopic topic = new NewTopic(topicName, 5, 1);
        return topic.configs((Map)DEFAULT_TOPIC_CONFIG);
    }

    @Nonnull
    @Bean
    public NewTopic conversionStatusTopic() {
        return KafkaTopicConfiguration.topicFactory((String)"just.documents.conversion.status");
    }

    @Nonnull
    @Bean(value={"conversionTaskTopic"})
    public NewTopic conversionTaskTopic() {
        return KafkaTopicConfiguration.topicFactory((String)"just.documents.conversion.taskv2");
    }
}

