/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.business.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import de.justsoftware.jdoc.model.DocumentStatus;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.model.persistence.conversion.ConversionRequest;
import de.justsoftware.jdoc.services.TempFileService;
import de.justsoftware.jdoc.services.business.DocumentConversionExecutor;
import de.justsoftware.jdoc.services.business.DocumentConversionService;
import de.justsoftware.jdoc.services.business.DocumentService;
import de.justsoftware.jdoc.services.business.impl.DocumentConversionExecutorImpl;
import de.justsoftware.jdoc.services.conversion.DocumentConverterService;
import de.justsoftware.jdoc.services.exceptions.DocumentConversionException;
import de.justsoftware.jdoc.services.exceptions.DocumentNotFoundException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadWriteException;
import de.justsoftware.jdoc.services.exceptions.DocumentResourceNotFoundException;
import de.justsoftware.jdoc.services.persistence.DocumentConversionDAO;
import de.justsoftware.jdoc.util.JustDocUtil;
import de.justsoftware.jdoc.util.ZipUtil;
import de.justsoftware.jdoc.util.streams.DocumentInputStream;
import de.justsoftware.judoclient.conversionstatus.ConversionStatusClient;
import de.justsoftware.judoclient.model.ConversionStatus;
import de.justsoftware.judoclient.model.Keyable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.Executor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.core.task.support.TaskExecutorAdapter;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class DocumentConversionExecutorImpl
implements DocumentConversionExecutor {
    private static final Object PULL_LOCK = new Object();
    private static final Logger LOG = LoggerFactory.getLogger(DocumentConversionExecutorImpl.class);
    private final DocumentService _documentService;
    private final ConversionStatusClient _conversionStatusClient;
    private final DocumentConversionDAO _conversionDAO;
    private final DocumentConversionService _conversionService;
    private final ImmutableList<DocumentConverterService> _converterServices;
    private final TaskExecutorAdapter _taskExecutor;
    private final TempFileService _tempFileService;

    @Autowired
    public DocumentConversionExecutorImpl(DocumentService documentService, ConversionStatusClient conversionStatusClient, DocumentConversionService documentConversionService, DocumentConversionDAO documentConversionDAO, Collection<DocumentConverterService> converterServices, @Qualifier(value="conversionExecutor") Executor executor, TempFileService tempFileService) {
        this._documentService = documentService;
        this._conversionStatusClient = conversionStatusClient;
        this._conversionService = documentConversionService;
        this._conversionDAO = documentConversionDAO;
        this._converterServices = FluentIterable.from(converterServices).toList();
        this._taskExecutor = new TaskExecutorAdapter(executor);
        this._tempFileService = tempFileService;
    }

    public void doOneConversion() {
        if (this._conversionDAO.hasConversionRequest()) {
            try {
                this._taskExecutor.submit((Runnable)new DocumentConversionCallable(this));
            }
            catch (TaskRejectedException e) {
                LOG.trace("execution was rejected due to too much load - this is ok");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private DocumentStatus doConvertDocument(DocumentConverterService converter, ConversionRequest request, File workDir) throws DocumentConversionException {
        File tmpDir = new File(workDir, "temp");
        if (!tmpDir.mkdirs()) {
            LOG.warn("temp directory " + tmpDir.getAbsolutePath() + " could not be created.");
        }
        File targetFileOrFolder = new File(workDir, "target");
        try {
            File sourceFile = this.downloadSourceFile(request, workDir);
            DocumentStatus processingResult = converter.process(sourceFile, targetFileOrFolder, tmpDir, request.getMaxRuntime());
            DocumentStatus documentStatus = this.analyzeResult(request, processingResult, targetFileOrFolder, workDir);
            return documentStatus;
        }
        catch (DocumentNotFoundException dnfe) {
            LOG.error("Conversion for preview id '{}' failed because source file could not be fetched.", (Object)request.getDocumentId());
            DocumentStatus documentStatus = DocumentStatus.ERROR;
            return documentStatus;
        }
        finally {
            this._tempFileService.cleanupTempDirectory(tmpDir);
        }
    }

    @Nonnull
    private DocumentStatus analyzeResult(ConversionRequest request, DocumentStatus processingResult, File targetFileOrFolder, File workDir) throws DocumentConversionException {
        String messageTemplate = "Conversion result for preview id '" + String.valueOf(request.getDocumentId()) + "' is {}.";
        switch (1.$SwitchMap$de$justsoftware$jdoc$model$DocumentStatus[processingResult.ordinal()]) {
            case 1: {
                LOG.debug(messageTemplate, (Object)processingResult);
                switch (1.$SwitchMap$de$justsoftware$jdoc$model$DocumentUploadType[request.getTargetType().uploadType().ordinal()]) {
                    case 1: {
                        this.uploadArchiveFolder(request, targetFileOrFolder, workDir);
                        break;
                    }
                    case 2: {
                        this.uploadFile(request, targetFileOrFolder);
                        return DocumentStatus.PROCESSING;
                    }
                }
                return DocumentStatus.PRESENT;
            }
            case 2: 
            case 3: {
                LOG.warn(messageTemplate, (Object)processingResult);
                return DocumentStatus.ERROR;
            }
            case 4: {
                LOG.debug(messageTemplate, (Object)processingResult);
                return DocumentStatus.UNSUPPORTED;
            }
            case 5: {
                LOG.debug(messageTemplate, (Object)processingResult);
                return DocumentStatus.NOT_PRESENT;
            }
            case 6: {
                LOG.debug(messageTemplate, (Object)processingResult);
                return DocumentStatus.CLEANED_UP;
            }
        }
        LOG.error("Conversion for preview id '{}' exited with an unknown state '{}'.", (Object)request.getDocumentId(), (Object)processingResult);
        return DocumentStatus.ERROR;
    }

    @Nonnull
    private File downloadSourceFile(ConversionRequest message, File tempDir) throws DocumentConversionException, DocumentNotFoundException {
        try {
            File targetFile = new File(tempDir, message.getSourceType().toFilename(message.getDocumentId()));
            FileUtils.copyInputStreamToFile((InputStream)this._documentService.getDocumentStream(message.getDocumentId(), message.getSourceType()), (File)targetFile);
            return targetFile;
        }
        catch (DocumentReadException e) {
            throw new DocumentConversionException("Download of document for preview id '" + String.valueOf(message.getDocumentId()) + "' failed!", (Throwable)e);
        }
        catch (DocumentResourceNotFoundException e) {
            throw new DocumentConversionException("Document resource for preview id '" + String.valueOf(message.getDocumentId()) + "' not present, can't download", (Throwable)e);
        }
        catch (IOException e) {
            throw new DocumentConversionException("IO failed for download of document for preview id '" + String.valueOf(message.getDocumentId()) + "'!", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uploadArchiveFolder(ConversionRequest message, File uploadFolder, File tempDir) throws DocumentConversionException {
        File targetFile = new File(tempDir, "target.zip");
        DocumentInputStream uploadStream = null;
        try {
            ZipUtil.zipFolder((File)uploadFolder, (File)targetFile);
            uploadStream = JustDocUtil.createStream((File)targetFile);
            this._documentService.createDocumentFromUpload(message.getDocumentId(), message.getTargetType(), uploadStream);
        }
        catch (IOException e) {
            try {
                throw new DocumentConversionException("can't create archive for folder " + uploadFolder.getAbsolutePath(), (Throwable)e);
                catch (DocumentReadException e2) {
                    throw new DocumentConversionException("can't read zip upload file " + targetFile.getAbsolutePath() + " for upload!", (Throwable)e2);
                }
                catch (DocumentReadWriteException e3) {
                    throw new DocumentConversionException("can't upload file " + targetFile.getAbsolutePath(), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(uploadStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)uploadStream);
    }

    private void uploadFile(ConversionRequest message, File targetFile) throws DocumentConversionException {
        DocumentInputStream uploadStream = null;
        try {
            uploadStream = JustDocUtil.createStream((File)targetFile);
            this._documentService.createDocumentFromUpload(message.getDocumentId(), message.getTargetType(), uploadStream);
        }
        catch (DocumentReadException e) {
            throw new DocumentConversionException("can't read file " + targetFile.getAbsolutePath() + " for upload!", (Throwable)e);
        }
        catch (DocumentReadWriteException e) {
            throw new DocumentConversionException("can't upload file " + targetFile.getAbsolutePath(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)uploadStream);
        }
    }

    @CheckForNull
    private DocumentConverterService findConverter(DocumentType sourceType, DocumentType targetType) {
        return (DocumentConverterService)FluentIterable.from((Iterable)this._converterServices).filter((Predicate)new ActiveDocumentConverterLookupPredicate(sourceType, targetType)).first().orNull();
    }

    private void updateStatus(ConversionRequest message, DocumentStatus status) {
        this._conversionService.setDocumentStatus(message.getTargetType(), message.getDocumentId(), status);
        ConversionStatus newConversionStatus = new ConversionStatus(message.getDocumentId().toString(), status.asTaskStatus());
        this._conversionStatusClient.dispatch((Keyable)newConversionStatus);
    }
}

