/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.judo.services.runner;

import com.google.common.collect.EvictingQueue;
import de.justsoftware.jdoc.services.conversion.exceptions.InvalidShellScriptException;
import de.justsoftware.jdoc.services.conversion.exceptions.ShellScriptExecutionException;
import de.justsoftware.jdoc.services.monitoring.ResettableHealthIndicator;
import de.justsoftware.jdoc.services.monitoring.model.HeartbeatStatus;
import de.justsoftware.jdoc.services.tasks.processes.ProcessWatchdogService;
import de.justsoftware.jdoc.services.tasks.processes.model.WatchedProcessId;
import de.justsoftware.judoclient.model.ConversionTask;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

@ParametersAreNonnullByDefault
public abstract class ScriptRunnerService
extends ResettableHealthIndicator {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptRunnerService.class);
    private final ProcessWatchdogService _watchdogService;
    private final int _maxExecutionTime;
    private final Counter _errorCounter;
    private final Counter _totalCounter;
    private final EvictingQueue<HeartbeatStatus> _monitoringStatusQueue;
    private final int _statusQueueSize;
    private final int _errorCountThreshold;

    ScriptRunnerService(String scriptName, ProcessWatchdogService watchdogService, int maxExecutionTime, MeterRegistry meterRegistry, int statusQueueSize, int errorCountThreshold) {
        this._watchdogService = watchdogService;
        this._maxExecutionTime = maxExecutionTime;
        this._statusQueueSize = statusQueueSize;
        this._errorCountThreshold = errorCountThreshold;
        this._totalCounter = meterRegistry.counter(scriptName + ".conversion.total", new String[0]);
        this._errorCounter = meterRegistry.counter(scriptName + ".conversion.error", new String[0]);
        this._monitoringStatusQueue = EvictingQueue.create((int)this._statusQueueSize);
    }

    @Nonnull
    abstract String[] getScriptArguments(File var1, ConversionTask var2) throws IOException;

    @Nonnull
    abstract File getScriptFile() throws IOException;

    @Nonnull
    abstract Executor getScriptExecutor();

    public void process(File source, ConversionTask conversion) throws ShellScriptExecutionException, InvalidShellScriptException {
        try {
            CommandLine cmdLine = this.getScriptCommand().addArguments(this.getScriptArguments(source, conversion));
            this.execute(cmdLine);
            this.handleExecutionResult(HeartbeatStatus.OK);
        }
        catch (InvalidShellScriptException e) {
            this.handleExecutionResult(HeartbeatStatus.ERROR);
            this._errorCounter.increment();
            LOG.error("error creating cmdLine", (Throwable)e);
            throw new InvalidShellScriptException(e.getMessage());
        }
        catch (IOException e) {
            this.handleExecutionResult(HeartbeatStatus.ERROR);
            LOG.error("error getting script file", (Throwable)e);
            throw new InvalidShellScriptException(e.getMessage());
        }
    }

    private void execute(CommandLine cmdLine) throws ShellScriptExecutionException {
        WatchedProcessId watchedId = this._watchdogService.addProcessToWatch(cmdLine, (long)this._maxExecutionTime);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        Executor executor = this.getScriptExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)out, (OutputStream)err));
        try {
            executor.execute(cmdLine);
        }
        catch (IOException e) {
            this.handleExecutionResult(HeartbeatStatus.ERROR);
            throw new ShellScriptExecutionException(cmdLine, out, err, (Exception)e);
        }
        finally {
            this._watchdogService.removeProcessFromWatch(watchedId);
        }
    }

    @Nonnull
    private CommandLine getScriptCommand() throws InvalidShellScriptException, IOException {
        File scriptFile = this.getScriptFile();
        if (!scriptFile.exists() || !scriptFile.isFile()) {
            throw new InvalidShellScriptException(scriptFile.getAbsolutePath() + " is missing");
        }
        if (!scriptFile.canRead()) {
            throw new InvalidShellScriptException(scriptFile.getAbsolutePath() + " can't be read");
        }
        if (!scriptFile.canExecute() && !scriptFile.setExecutable(true)) {
            throw new InvalidShellScriptException(scriptFile.getAbsolutePath() + " can't process");
        }
        return new CommandLine(scriptFile);
    }

    private void handleExecutionResult(HeartbeatStatus status) {
        this._monitoringStatusQueue.add((Object)status);
        this._totalCounter.increment();
        if (status == HeartbeatStatus.ERROR) {
            this._errorCounter.increment();
        }
    }

    protected void doHealthCheck(Health.Builder builder) {
        Status status = Status.UP;
        long errorCount = this._monitoringStatusQueue.stream().filter(arg_0 -> HeartbeatStatus.ERROR.equals(arg_0)).count();
        builder.withDetail("monitoring state error/conversions", (Object)String.format("%d/%d", errorCount, this._monitoringStatusQueue.size()));
        builder.withDetail("error threshold", (Object)String.format("%d out of %d", this._errorCountThreshold, this._statusQueueSize));
        builder.withDetail("errors since startup", (Object)this._errorCounter.count());
        builder.withDetail("total since startup", (Object)this._totalCounter.count());
        if (errorCount >= (long)this._errorCountThreshold) {
            status = Status.DOWN;
        }
        builder.status(status);
    }

    public void resetStatus() {
        LOG.info("resetting monitoringStatusQueue by clearing entries");
        this._monitoringStatusQueue.clear();
    }
}

