/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.judo.services.impl;

import de.justsoftware.judo.services.FileCacheService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FileCacheServiceImpl
implements FileCacheService {
    private static final Logger LOG = LoggerFactory.getLogger(FileCacheServiceImpl.class);
    @Value(value="${services.filecache.cache_dir}")
    private String _cacheDir;
    @Value(value="${services.filecache.converted_dir}")
    private String _convertedDir;

    @Nonnull
    private File createDir(String dirToCraete) throws IOException {
        File dir = new File(dirToCraete);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Folder " + dir.getAbsolutePath() + " can't be created!");
        }
        if (!dir.isDirectory()) {
            throw new IOException("A file by name " + dir.getAbsolutePath() + " already exists, can't create folder!");
        }
        Files.setPosixFilePermissions(dir.toPath(), PosixFilePermissions.fromString("rwxrwxrwx"));
        return dir;
    }

    @Nonnull
    private File createCacheFile(String id) throws IOException {
        return new File(this.createDir(this._cacheDir), id);
    }

    @Nonnull
    public File getConvertedFile(String id) throws IOException {
        File converted = this.getConvertedFileLocation(id);
        if (!converted.exists()) {
            throw new IOException("Converted File for Conversion " + id + " does not exist!");
        }
        return converted;
    }

    @Nonnull
    public File getConvertedFileLocation(String id) throws IOException {
        return new File(this.createDir(this._convertedDir), id);
    }

    @Nonnull
    public File downloadToFileCache(String id, String remoteUrl) throws IOException {
        File file;
        LOG.debug("Download original from Storageserver for preview id '{}'.", (Object)id);
        InputStream inputStream = null;
        File targetFile = null;
        try {
            targetFile = this.createCacheFile(id);
            URL remoteFile = new URL(remoteUrl);
            URLConnection connection = remoteFile.openConnection();
            int contentLength = connection.getContentLength();
            inputStream = connection.getInputStream();
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
            if (contentLength != -1 && (long)contentLength != targetFile.length()) {
                throw new IOException("Expected a file of length " + contentLength + " but only " + targetFile.length() + " were written!");
            }
            file = targetFile;
        }
        catch (IOException e) {
            try {
                FileUtils.deleteQuietly((File)targetFile);
                throw new IOException("could not download: " + remoteUrl, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return file;
    }

    public void removeFromFileCache(String id) throws IOException {
        FileUtils.deleteQuietly((File)this.createCacheFile(id));
    }
}

