/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.judo.kafka;

import de.justsoftware.judoclient.conversionstatus.ConversionStatusClient;
import de.justsoftware.judoclient.conversiontask.ConversionTaskDeserializer;
import de.justsoftware.judoclient.model.ConversionTask;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

@Configuration
@ParametersAreNonnullByDefault
@EnableKafka
public class KafkaConfiguration {
    public static final Duration THIRTY_SECONDS_BACKOFF_INTERVALL = Duration.ofSeconds(30L);
    @Value(value="${spring.kafka.bootstrapServers}")
    private String _bootstrapServers;

    @Bean(destroyMethod="close")
    @Nonnull
    public KafkaProducer<String, String> kafkaProducer() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("acks", "all");
        props.put("retries", (Object)0);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)1);
        props.put("buffer.memory", (Object)0x2000000);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    @Nonnull
    public ConversionStatusClient conversionStatusClient(KafkaProducer<String, String> kafkaProducer) {
        return new ConversionStatusClient(kafkaProducer);
    }

    @Bean
    @Nonnull
    public ConcurrentKafkaListenerContainerFactory<String, ConversionTask> conversionTaskListenerContainerFactory() {
        HashMap props = this.newConsumerFactoryPropsWithDefaults();
        props.put("group.id", "just.documents.ConversionTaskProcessorV2");
        props.put("spring.deserializer.key.delegate.class", StringDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", ConversionTaskDeserializer.class);
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        FixedBackOff backOff = new FixedBackOff(THIRTY_SECONDS_BACKOFF_INTERVALL.toMillis(), 1L);
        DefaultErrorHandler commonErrorHandler = new DefaultErrorHandler((BackOff)backOff);
        commonErrorHandler.setLogLevel(KafkaException.Level.WARN);
        factory.setCommonErrorHandler((CommonErrorHandler)commonErrorHandler);
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory((Map)props);
        factory.setConsumerFactory((ConsumerFactory)consumerFactory);
        return factory;
    }

    @Nonnull
    private HashMap<String, Object> newConsumerFactoryPropsWithDefaults() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("auto.offset.reset", "latest");
        props.put("max.poll.interval.ms", (int)Duration.ofHours(1L).toMillis());
        props.put("max.poll.records", 1);
        props.put("key.deserializer", ErrorHandlingDeserializer.class);
        props.put("value.deserializer", ErrorHandlingDeserializer.class);
        return props;
    }
}

