/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.util;

import com.google.common.collect.ImmutableList;
import de.justsoftware.jdoc.services.exceptions.DocumentReadException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadWriteException;
import de.justsoftware.jdoc.util.FileExtensionContentTypeMapping;
import de.justsoftware.jdoc.util.streams.DocumentInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.AutoCloseInputStream;

@ParametersAreNonnullByDefault
public class JustDocUtil {
    public static void copyStream(InputStream input, File output) throws DocumentReadWriteException {
        try {
            FileUtils.copyInputStreamToFile((InputStream)input, (File)output);
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)output);
            throw new DocumentReadWriteException("Error while writing stream to file " + output.getAbsolutePath(), (Throwable)e);
        }
    }

    @Nonnull
    public static DocumentInputStream createStream(File file) throws DocumentReadException {
        try {
            return new DocumentInputStream((InputStream)new AutoCloseInputStream((InputStream)FileUtils.openInputStream((File)file)), file.length(), FileExtensionContentTypeMapping.contentTypeByFilename((String)file.getName()));
        }
        catch (IOException e) {
            throw new DocumentReadException("Error on stream open for file " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    @Nonnull
    public static Iterable<File> listFiles(File fileOrFolder, FileFilter filter) {
        Object[] listFiles = fileOrFolder.isDirectory() ? fileOrFolder.listFiles(filter) : null;
        return listFiles != null ? ImmutableList.copyOf((Object[])listFiles) : ImmutableList.of();
    }
}

