/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.tasks.scheduled.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import de.justsoftware.jdoc.configuration.JustDocumentsEnvironment;
import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentInfo;
import de.justsoftware.jdoc.model.DocumentStatus;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.services.business.DocumentConversionExecutor;
import de.justsoftware.jdoc.services.business.DocumentConversionService;
import de.justsoftware.jdoc.services.business.DocumentService;
import de.justsoftware.jdoc.services.tasks.processes.ProcessWatchdogService;
import de.justsoftware.jdoc.services.tasks.scheduled.AsyncTaskService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class AsyncTaskServiceImpl
implements AsyncTaskService {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncTaskServiceImpl.class);
    private final DocumentService _documentService;
    private final DocumentConversionService _documentConversionService;
    private final DocumentConversionExecutor _conversionExecutor;
    private final ProcessWatchdogService _watchdogService;

    @Autowired
    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="leave it like it is")
    public AsyncTaskServiceImpl(DocumentService documentService, DocumentConversionService documentConversionService, DocumentConversionExecutor conversionExecutor, JustDocumentsEnvironment env, ProcessWatchdogService watchdogService) throws IOException {
        this._documentService = documentService;
        this._documentConversionService = documentConversionService;
        this._conversionExecutor = conversionExecutor;
        this._watchdogService = watchdogService;
        AsyncTaskServiceImpl.createExternalScripts((String)env.getConverterScriptPath());
    }

    private static void createExternalScripts(String converterScriptPath) throws IOException {
        Resource[] resources;
        File targetDirectory = new File(converterScriptPath);
        LOG.debug("update script folder " + targetDirectory.getAbsolutePath() + " with shell scripts from war");
        FileUtils.forceMkdir((File)targetDirectory);
        FileUtils.cleanDirectory((File)targetDirectory);
        for (Resource script : resources = new PathMatchingResourcePatternResolver().getResources("classpath*:scripts/*.*")) {
            String filename = script.getFilename();
            if (filename == null) {
                LOG.error("Filename is null");
                continue;
            }
            FileUtils.copyInputStreamToFile((InputStream)script.getInputStream(), (File)new File(targetDirectory, filename));
        }
        LOG.debug("scripts updated");
    }

    private void reenqueueConversionTasks() {
        LOG.debug("check for failed conversions");
        Iterable documentsIterable = this._documentService.getAllDocumentInfos();
        for (DocumentInfo info : Iterables.filter((Iterable)documentsIterable, (Predicate)Predicates.not(DocumentInfo::allStatusPresentOrCleanedUp))) {
            LOG.info("retry conversions for " + String.valueOf(info));
            this._documentConversionService.checkForConversions(info.getDocumentId());
        }
        LOG.debug("retry conversions done");
    }

    @Async
    @Scheduled(fixedDelay=5000L)
    public void checkProcesses() {
        this._watchdogService.checkProcesses();
    }

    @Async
    @Scheduled(cron="0 0 5 * * SUN,SAT")
    public void checkRepository() {
        LOG.info("Check repository sanity");
        long errorCount = 0L;
        for (DocumentInfo documentInfo : this._documentService.getAllDocumentInfos()) {
            for (Map.Entry entry : documentInfo.getDocumentStatus().entrySet()) {
                if (!this.checkDocument((DocumentType)entry.getKey(), (DocumentStatus)entry.getValue(), documentInfo.getDocumentId())) continue;
                ++errorCount;
            }
        }
        this.reenqueueConversionTasks();
        LOG.info("Done checking repository sanity, found {} errors.", (Object)errorCount);
    }

    @Async
    @Scheduled(fixedRate=5L)
    public void processConversion() {
        this._conversionExecutor.doOneConversion();
    }

    private boolean checkDocument(DocumentType type, DocumentStatus status, DocumentId documentId) {
        boolean isNotPresentButFound;
        boolean isPresent = this._documentService.hasDocument(type, documentId);
        boolean bl = isNotPresentButFound = !isPresent && DocumentStatus.PRESENT.equals((Object)status);
        if (isNotPresentButFound) {
            this._documentConversionService.retryConversionFromScratch(type, documentId);
        }
        return isNotPresentButFound;
    }
}

