/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.tasks.processes.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.jdoc.services.tasks.processes.model.CommandlineCallToWatch;
import de.justsoftware.jdoc.services.tasks.processes.model.NativeProcessData;
import de.justsoftware.jdoc.services.tasks.processes.model.NativeProcessId;
import de.justsoftware.jdoc.services.tasks.processes.model.WatchedProcessId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProcessToWatch {
    private final NativeProcessData _process;
    private final CommandlineCallToWatch _specification;

    public ProcessToWatch(NativeProcessData process, CommandlineCallToWatch specification) {
        this._process = process;
        this._specification = specification;
    }

    @Nonnull
    public NativeProcessData getProcess() {
        return this._process;
    }

    @Nonnull
    public CommandlineCallToWatch getSpecification() {
        return this._specification;
    }

    @Nonnull
    public WatchedProcessId getId() {
        return this._specification.getId();
    }

    @Nonnull
    public NativeProcessId getPid() {
        return this._process.getPid();
    }

    @Nonnull
    public NativeProcessId getParentPid() {
        return this._process.getParentPid();
    }

    @Nonnull
    public String getFullCommand() {
        return this._process.getFullCommand();
    }

    public void markAsSurvivor() {
        this._specification.markAsSurvivor();
    }

    @Nonnull
    public ImmutableSet<String> getIdentifiers() {
        return this._specification.getIdentifiers();
    }

    public long getCreationDate() {
        return this._specification.getCreationDate();
    }

    public long getMaxRuntimeInMillis() {
        return this._specification.getMaxRuntimeInMillis();
    }

    public boolean isSurvivor() {
        return this._specification.isSurvivor();
    }

    public void setSurvivor(boolean survivor) {
        this._specification.setSurvivor(survivor);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pid", (Object)this._process.getPid()).add("parentPid", (Object)this._process.getParentPid()).add("fullCommand", (Object)this._process.getFullCommand()).add("creationDate", this._specification.getCreationDate()).add("maxRuntimeInMillis", this._specification.getMaxRuntimeInMillis()).add("survivor", this._specification.isSurvivor()).toString();
    }
}

