/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.persistence;

import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.services.exceptions.DocumentNotFoundException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadWriteException;
import de.justsoftware.jdoc.services.exceptions.DocumentResourceNotFoundException;
import de.justsoftware.jdoc.util.streams.DocumentInputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface DocumentRepository {
    public void createDocument(DocumentId var1) throws DocumentReadWriteException;

    public void deleteDocument(DocumentId var1) throws DocumentNotFoundException, DocumentReadWriteException;

    public boolean hasDocument(DocumentId var1);

    public boolean hasDocument(DocumentType var1, DocumentId var2);

    public void writeDocument(DocumentType var1, DocumentId var2, DocumentInputStream var3) throws DocumentReadWriteException;

    @Nonnull
    public DocumentInputStream readDocument(DocumentType var1, DocumentId var2) throws DocumentNotFoundException, DocumentReadException, DocumentResourceNotFoundException;

    @Nonnull
    public DocumentInputStream readDocumentResource(DocumentType var1, DocumentId var2, String var3) throws DocumentNotFoundException, DocumentResourceNotFoundException, DocumentReadException;

    @Nonnegative
    public long getDocumentCount();

    @Nonnull
    public Iterable<DocumentId> getAllDocumentIds();

    @Nonnegative
    public long getDocumentSize(DocumentType var1, DocumentId var2);
}

