/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.conversion.impl;

import de.justsoftware.jdoc.configuration.JustDocumentsEnvironment;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.services.conversion.impl.ShellScriptExecutingConverterService;
import de.justsoftware.jdoc.services.tasks.processes.ProcessWatchdogService;
import io.micrometer.core.instrument.MeterRegistry;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ParametersAreNonnullByDefault
public class ConverterConfiguration {
    @Value(value="${judo.monitoring.pdf.queueSize: 10}")
    private int _monitoringQueueSize;
    @Value(value="${judo.monitoring.pdf.errorThreshold: 8}")
    private int _monitoringErrorThreshold;

    @Nonnull
    @Bean(value={"any2pdfConverter"})
    @Lazy(value=false)
    public ShellScriptExecutingConverterService any2pdfConverter(JustDocumentsEnvironment env, ProcessWatchdogService watchdog, MeterRegistry meterRegistry) {
        return new ShellScriptExecutingConverterService(DocumentType.ORIGINAL, DocumentType.PDF, env, "any2pdf.sh", watchdog, meterRegistry, this._monitoringQueueSize, this._monitoringErrorThreshold);
    }

    @Nonnull
    @Bean(value={"pdf2htmlConverter"})
    @Lazy(value=false)
    public ShellScriptExecutingConverterService pdf2htmlConverter(JustDocumentsEnvironment env, ProcessWatchdogService watchdog, MeterRegistry meterRegistry) {
        return new ShellScriptExecutingConverterService(DocumentType.PDF, DocumentType.HTML, env, "pdf2jpeghtml.sh", watchdog, meterRegistry, this._monitoringQueueSize, this._monitoringErrorThreshold);
    }
}

