/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.business.impl;

import com.google.common.collect.ImmutableList;
import de.justsoftware.jdoc.configuration.JustDocumentsEnvironment;
import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentStatus;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.model.persistence.conversion.ConversionLog;
import de.justsoftware.jdoc.model.persistence.conversion.ConversionRequest;
import de.justsoftware.jdoc.services.business.DocumentConversionService;
import de.justsoftware.jdoc.services.business.impl.DocumentConversionServiceImpl;
import de.justsoftware.jdoc.services.persistence.DocumentConversionDAO;
import de.justsoftware.jdoc.services.persistence.DocumentRepository;
import de.justsoftware.jdoc.util.DocumentConversionUtil;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class DocumentConversionServiceImpl
implements DocumentConversionService {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentConversionServiceImpl.class);
    private final JustDocumentsEnvironment _env;
    private final DocumentRepository _repository;
    private final DocumentConversionDAO _conversionDAO;

    @Autowired
    public DocumentConversionServiceImpl(DocumentRepository repository, DocumentConversionDAO documentConversionDAO, JustDocumentsEnvironment env) {
        this._repository = repository;
        this._conversionDAO = documentConversionDAO;
        this._env = env;
    }

    public void setDocumentStatus(DocumentType type, DocumentId documentId, DocumentStatus status) {
        DocumentStatus currentStatus = this._conversionDAO.getDocumentStatus(type, documentId);
        if (!currentStatus.equals((Object)status)) {
            this._conversionDAO.setDocumentStatus(type, documentId, status);
            this.onDocumentStatusChange(type, documentId, status);
        }
    }

    public void retryConversionFromScratch(DocumentType type, DocumentId documentId) {
        this._conversionDAO.resetConversionLogStatus(type, documentId);
        this.setDocumentStatus(type, documentId, DocumentStatus.ERROR);
    }

    private void onDocumentStatusChange(DocumentType type, DocumentId documentId, DocumentStatus status) {
        LOG.debug("document " + String.valueOf(documentId) + " (" + String.valueOf(type) + ") status changed :" + String.valueOf(status));
        switch (1.$SwitchMap$de$justsoftware$jdoc$model$DocumentStatus[status.ordinal()]) {
            case 1: {
                for (DocumentType dependendType : type.produces()) {
                    this.setDocumentStatus(dependendType, documentId, status);
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.checkForConversions(documentId);
                break;
            }
        }
    }

    public void checkForConversions(DocumentId documentId) {
        DocumentStatus originalStatus = this._conversionDAO.getDocumentStatus(DocumentType.ORIGINAL, documentId);
        if (!originalStatus.isFinal()) {
            this.setDocumentStatus(DocumentType.ORIGINAL, documentId, DocumentStatus.UNSUPPORTED);
        } else {
            ImmutableList.Builder requests = ImmutableList.builder();
            this.checkForConversions(requests, documentId, DocumentType.ORIGINAL, originalStatus);
            this.enqueueConversionRequest((Iterable)requests.build());
        }
    }

    private void checkForConversions(ImmutableList.Builder<ConversionRequest> requests, DocumentId documentId, DocumentType sourceType, DocumentStatus sourceStatus) {
        for (DocumentType targetType : sourceType.produces()) {
            this.checkForConversions(requests, documentId, sourceType, sourceStatus, targetType);
        }
    }

    private void checkForConversions(ImmutableList.Builder<ConversionRequest> requests, DocumentId documentId, DocumentType sourceType, DocumentStatus sourceStatus, DocumentType targetType) {
        DocumentStatus statusOfSourceType = sourceStatus;
        switch (1.$SwitchMap$de$justsoftware$jdoc$model$DocumentStatus[statusOfSourceType.ordinal()]) {
            case 3: {
                DocumentStatus statusOfTargetType = this._conversionDAO.getDocumentStatus(targetType, documentId);
                switch (1.$SwitchMap$de$justsoftware$jdoc$model$DocumentStatus[statusOfTargetType.ordinal()]) {
                    case 3: {
                        this.checkForConversions(requests, documentId, targetType, statusOfTargetType);
                        return;
                    }
                    case 1: {
                        return;
                    }
                }
                requests.add((Object)this.createDocumentConversionRequest(documentId, sourceType, targetType));
                return;
            }
            case 1: {
                this.setDocumentStatus(targetType, documentId, DocumentStatus.UNSUPPORTED);
                return;
            }
        }
        this.setDocumentStatus(targetType, documentId, DocumentStatus.NOT_PRESENT);
    }

    private void enqueueConversionRequest(Iterable<ConversionRequest> requests) {
        for (ConversionRequest request : requests) {
            if (DocumentConversionUtil.isSupported((int)request.getAttemptCount())) {
                LOG.debug("add conversion request :" + String.valueOf(request));
                boolean enqueued = this._conversionDAO.addConversionRequest(request);
                if (enqueued) {
                    this.setDocumentStatus(request.getTargetType(), request.getDocumentId(), DocumentStatus.QUEUED);
                    continue;
                }
                this.setDocumentStatus(request.getTargetType(), request.getDocumentId(), DocumentStatus.ERROR);
                continue;
            }
            LOG.error("conversion from " + String.valueOf(request.getSourceType()) + " to " + String.valueOf(request.getTargetType()) + " is not supported! Request denied :" + String.valueOf(request));
            this.setDocumentStatus(request.getTargetType(), request.getDocumentId(), DocumentStatus.UNSUPPORTED);
        }
    }

    @Nonnull
    private ConversionRequest createDocumentConversionRequest(DocumentId documentId, DocumentType sourceType, DocumentType targetType) {
        long fileSize = this._repository.getDocumentSize(sourceType, documentId);
        ConversionLog conversionLog = this._conversionDAO.getConversionLog(documentId);
        int attemptCount = DocumentConversionUtil.countErrors((ConversionLog)conversionLog, (DocumentType)sourceType, (DocumentType)targetType, (String)this._env.getVersion());
        return new ConversionRequest(documentId, sourceType, targetType, this._env.getMaxConversionDurationMillis(), attemptCount, fileSize, System.currentTimeMillis());
    }

    public void resetConversionRequestQueue() {
        this._conversionDAO.resetConversionRequestQueue();
    }

    public DocumentStatus getDocumentStatus(DocumentType type, DocumentId documentId) {
        return this._conversionDAO.getDocumentStatus(type, documentId);
    }
}

