/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.application;

import de.justsoftware.jdoc.configuration.JustDocumentsEnvironment;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.EnableScheduling;

@Profile(value={"!test"})
@Configuration
@EnableScheduling
@ParametersAreNonnullByDefault
public class TaskConfiguration {
    @Nonnull
    @Bean(value={"conversionExecutor"})
    public ThreadPoolExecutor conversionExecutor(JustDocumentsEnvironment env) {
        return new ThreadPoolExecutor(0, env.getConverterMaxConcurrent(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10));
    }

    @Nonnull
    @Bean(value={"genericTaskExecutor"})
    public ThreadPoolExecutor genericTaskExecutor() {
        return new ThreadPoolExecutor(0, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(50));
    }
}

