/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.persistence.model.DbReactionId;
import de.justsoftware.chat.persistence.model.DbRemovedMessageReactionForSync;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007H'J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/chat/persistence/RemovedMessageReactionForSyncRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/chat/persistence/model/DbRemovedMessageReactionForSync;", "Lde/justsoftware/chat/persistence/model/DbReactionId;", "deleteByUpdatedAtLessThan", "", "since", "Ljava/time/Instant;", "findByUpdatedAtGreaterThanAndParticipantIdsIn", "", "participantIds", "", "", "updatedAt", "findByUpdatedAtGreaterThanAndParticipantIds", "chat-service"})
@SourceDebugExtension(value={"SMAP\nRemovedMessageReactionForSyncRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemovedMessageReactionForSyncRepository.kt\nde/justsoftware/chat/persistence/RemovedMessageReactionForSyncRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1374#2:55\n1460#2,5:56\n*S KotlinDebug\n*F\n+ 1 RemovedMessageReactionForSyncRepository.kt\nde/justsoftware/chat/persistence/RemovedMessageReactionForSyncRepository\n*L\n52#1:55\n52#1:56,5\n*E\n"})
public interface RemovedMessageReactionForSyncRepository
extends JpaRepository<DbRemovedMessageReactionForSync, DbReactionId> {
    @Modifying
    @Query(value="\n            DELETE\n            FROM DbRemovedMessageReactionForSync r\n            WHERE r.updatedAt < :since\n        ")
    public int deleteByUpdatedAtLessThan(@NotNull Instant var1);

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="findByUpdatedAtGreaterThanAndParticipantIds(participantIds, updatedAt)", imports={}))
    @Query(value="\n        SELECT new de.justsoftware.chat.persistence.model.DbReactionId(r.messageId, r.profileId)\n        FROM DbRemovedMessageReactionForSync r\n        WHERE r.updatedAt > :updatedAt\n        AND EXISTS (\n            SELECT 1\n            FROM DbChatMessage m\n            JOIN DbChatParticipant cp ON cp.chatId = m.chatId\n            WHERE m.id = r.messageId\n            AND cp.participantId IN :participantIds\n        )\n        ")
    @NotNull
    public List<DbReactionId> findByUpdatedAtGreaterThanAndParticipantIdsIn(@NotNull Iterable<String> var1, @NotNull Instant var2);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<DbReactionId> findByUpdatedAtGreaterThanAndParticipantIds(@NotNull Iterable<String> participantIds, @NotNull Instant updatedAt) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(participantIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findByUpdatedAtGreaterThanAndParticipantIdsIn((Iterable)it, updatedAt);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

