/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.chat.business.model.event.ChatCreatedEvent;
import de.justsoftware.chat.kafka.DriveItemIdProducer;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.persistence.ChatRepository;
import de.justsoftware.chat.persistence.model.DbChatDto;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB+\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0017J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J\u001c\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0012R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/chat/kafka/DriveItemIdProducer;", "", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "chatRepository", "Lde/justsoftware/chat/persistence/ChatRepository;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lde/justsoftware/kafka/client/KafkaCleaningProducer;Lde/justsoftware/chat/persistence/ChatRepository;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "deleteChatFiles", "", "chatId", "Lde/justsoftware/chat/model/ChatId;", "syncChatItems", "onChatCreatedEvent", "event", "Lde/justsoftware/chat/business/model/event/ChatCreatedEvent;", "publishChatItem", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "send", "itemId", "driveCreateItem", "Lde/justsoftware/chat/kafka/DriveItemIdProducer$DriveCreateItem;", "DriveCreateItem", "Companion", "chat-service"})
public class DriveItemIdProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    private final ChatRepository chatRepository;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    public static final String TOPIC = "just.items";

    public DriveItemIdProducer(@NotNull KafkaCleaningProducer<String, String> kafkaProducer, @NotNull ChatRepository chatRepository, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        Intrinsics.checkNotNullParameter((Object)chatRepository, (String)"chatRepository");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.kafkaProducer = kafkaProducer;
        this.chatRepository = chatRepository;
        this.objectMapper = objectMapper;
    }

    public void deleteChatFiles(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        DriveItemIdProducer.send$default((DriveItemIdProducer)this, (ChatId)chatId, null, (int)2, null);
    }

    @Transactional
    public void syncChatItems() {
        this.chatRepository.streamAll().forEach(arg_0 -> DriveItemIdProducer.syncChatItems$lambda$1(arg_0 -> DriveItemIdProducer.syncChatItems$lambda$0(this, arg_0), arg_0));
    }

    @EventListener
    public void onChatCreatedEvent(@NotNull ChatCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.publishChatItem(event.getChat().getId(), event.getChat().getTenantId());
    }

    private void publishChatItem(ChatId chatId, TenantId tenantId) {
        this.send(chatId, new DriveCreateItem(tenantId.toCanonicalId()));
    }

    private void send(ChatId itemId, DriveCreateItem driveCreateItem) {
        String value = driveCreateItem != null ? this.objectMapper.writeValueAsString((Object)driveCreateItem) : null;
        this.kafkaProducer.send(new ProducerRecord("just.items", (Object)itemId.toCanonicalId(), (Object)value));
        this.kafkaProducer.send(new ProducerRecord("just.items", (Object)itemId.toAssetPermissionId(), (Object)value));
    }

    static /* synthetic */ void send$default(DriveItemIdProducer driveItemIdProducer, ChatId chatId, DriveCreateItem driveCreateItem, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: send");
        }
        if ((n & 2) != 0) {
            driveCreateItem = null;
        }
        driveItemIdProducer.send(chatId, driveCreateItem);
    }

    private static final Unit syncChatItems$lambda$0(DriveItemIdProducer this$0, DbChatDto it) {
        this$0.publishChatItem(new ChatId(it.getId()), new TenantId(it.getTenantId()));
        return Unit.INSTANCE;
    }

    private static final void syncChatItems$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

