/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.application;

import de.justsoftware.chat.application.ChatMessageApplicationService;
import de.justsoftware.chat.application.model.ChatMessageDto;
import de.justsoftware.chat.application.model.ProfileDto;
import de.justsoftware.chat.application.model.SaveChatMessageDto;
import de.justsoftware.chat.application.model.SavePersonMentionDto;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.ChatLocalizationService;
import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.LoadDirection;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatMessageReaction;
import de.justsoftware.chat.business.model.PersonMention;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u0000 82\u00020\u0001:\u00018B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ<\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016JP\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0 2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J*\u0010)\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010*\u001a\u00020\u000bH\u0016J.\u0010+\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010/\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00100\u001a\u00020-2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u00101\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\"\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205032\f\u00106\u001a\b\u0012\u0004\u0012\u00020407H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lde/justsoftware/chat/application/ChatMessageApplicationService;", "", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "chatLocalizationService", "Lde/justsoftware/chat/business/ChatLocalizationService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "clock", "Ljava/time/Clock;", "editChatMessages", "", "<init>", "(Lde/justsoftware/chat/business/ChatMessageService;Lde/justsoftware/chat/business/ChatLocalizationService;Lde/justsoftware/chat/business/ProfileService;Ljava/time/Clock;Z)V", "createChatMessage", "Lde/justsoftware/chat/application/model/ChatMessageDto;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "saveChatMessageDto", "Lde/justsoftware/chat/application/model/SaveChatMessageDto;", "attachments", "", "Lorg/springframework/web/multipart/MultipartFile;", "savePersonMentionDtos", "Lde/justsoftware/chat/application/model/SavePersonMentionDto;", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "deleteChatMessage", "", "chatMessageId", "Lde/justsoftware/chat/model/ChatMessageId;", "getMessages", "Lorg/springframework/data/domain/Page;", "offsetTimestamp", "Ljava/time/Instant;", "offsetMessageId", "limit", "", "loadDirection", "Lde/justsoftware/chat/business/LoadDirection;", "includeOffsetMessage", "getChatMessage", "includeCitation", "edit", "newMessageText", "", "newPersonMentions", "react", "reaction", "deleteReaction", "findProfileDtos", "", "Lde/justsoftware/chat/model/ProfileId;", "Lde/justsoftware/chat/application/model/ProfileDto;", "profileIds", "", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatMessageApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageApplicationService.kt\nde/justsoftware/chat/application/ChatMessageApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,236:1\n1563#2:237\n1634#2,3:238\n1625#2:243\n1869#2:244\n1870#2:246\n1626#2:247\n1634#2,3:249\n1625#2:253\n1869#2:254\n1870#2:256\n1626#2:257\n1563#2:261\n1634#2,3:262\n1563#2:268\n1634#2,3:269\n1252#2,4:274\n1634#2,3:279\n1#3:241\n1#3:245\n1#3:255\n10#4:242\n7#4:248\n10#4:252\n19#4:258\n7#4:278\n97#5,2:259\n99#5,3:265\n463#6:272\n413#6:273\n*S KotlinDebug\n*F\n+ 1 ChatMessageApplicationService.kt\nde/justsoftware/chat/application/ChatMessageApplicationService\n*L\n56#1:237\n56#1:238,3\n117#1:243\n117#1:244\n117#1:246\n117#1:247\n119#1:249,3\n120#1:253\n120#1:254\n120#1:256\n120#1:257\n121#1:261\n121#1:262,3\n187#1:268\n187#1:269,3\n221#1:274,4\n159#1:279,3\n117#1:245\n120#1:255\n117#1:242\n119#1:248\n120#1:252\n121#1:258\n159#1:278\n121#1:259,2\n121#1:265,3\n221#1:272\n221#1:273\n*E\n"})
public class ChatMessageApplicationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final ChatLocalizationService chatLocalizationService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final Clock clock;
    private final boolean editChatMessages;
    @NotNull
    private static final Set<String> ALLOWED_REACTIONS;

    public ChatMessageApplicationService(@NotNull ChatMessageService chatMessageService, @NotNull ChatLocalizationService chatLocalizationService, @NotNull ProfileService profileService, @NotNull Clock clock, @Value(value="${just.chat.toggles.editChatMessages:true}") boolean editChatMessages) {
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)chatLocalizationService, (String)"chatLocalizationService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.chatMessageService = chatMessageService;
        this.chatLocalizationService = chatLocalizationService;
        this.profileService = profileService;
        this.clock = clock;
        this.editChatMessages = editChatMessages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ChatMessageDto createChatMessage(@NotNull ChatId chatId, @NotNull SaveChatMessageDto saveChatMessageDto, @NotNull List<? extends MultipartFile> attachments, @NotNull List<SavePersonMentionDto> savePersonMentionDtos, @NotNull AuthorizationContext authContext) throws ValidationException, NotAllowedException, NotFoundException {
        ChatMessageDto chatMessageDto;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)saveChatMessageDto, (String)"saveChatMessageDto");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter(savePersonMentionDtos, (String)"savePersonMentionDtos");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkWriteChat(chatId);
        Iterable $this$map$iv = savePersonMentionDtos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SavePersonMentionDto savePersonMentionDto = (SavePersonMentionDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SavePersonMentionDto.Companion.toPersonMention((SavePersonMentionDto)it, this.clock));
        }
        List personMentions = (List)destination$iv$iv;
        ChatMessage chatMessage = this.chatMessageService.create((ChatMessage)SaveChatMessageDto.Companion.toUserMessage(saveChatMessageDto, chatId, authContext.getProfileId(), this.clock, personMentions), attachments, true);
        ChatMessageId chatMessageId = saveChatMessageDto.getCitedMessageId();
        if (chatMessageId != null) {
            ChatMessageId it = chatMessageId;
            boolean bl = false;
            chatMessageDto = ChatMessageApplicationService.getChatMessage$default((ChatMessageApplicationService)this, (ChatId)chatId, (ChatMessageId)it, (AuthorizationContext)authContext, (boolean)false, (int)8, null);
        } else {
            chatMessageDto = null;
        }
        ChatMessageDto citation = chatMessageDto;
        return ChatMessageDto.Companion.toChatMessageDto$default((ChatMessageDto.Companion)ChatMessageDto.Companion, (ChatMessage)chatMessage, (ProfileDto)ProfileDto.Companion.toProfileDto(this.profileService.getById(chatMessage.getAuthor())), (String)this.chatLocalizationService.localizeMessage(chatMessage, authContext), (ChatMessageDto)citation, null, (int)8, null);
    }

    public void deleteChatMessage(@NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChatMessage chatMessage = this.chatMessageService.getById(chatMessageId);
        authContext.checkReadChat(chatMessage.getChatId());
        this.chatMessageService.delete(chatMessageId, authContext.getProfileId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<ChatMessageDto> getMessages(@NotNull ChatId chatId, @Nullable Instant offsetTimestamp, @Nullable ChatMessageId offsetMessageId, int limit, @NotNull LoadDirection loadDirection, boolean includeOffsetMessage, @NotNull AuthorizationContext authContext) {
        void $this$flatMapTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNullToSet$iv;
        Instant offset;
        Instant offsetMessage;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)loadDirection, (String)"loadDirection");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        ChatMessageId chatMessageId = offsetMessageId;
        if (chatMessageId != null) {
            ChatMessageId chatMessageId2 = chatMessageId;
            ChatMessageService chatMessageService = this.chatMessageService;
            ChatMessageId p0 = chatMessageId2;
            boolean bl = false;
            v1 = chatMessageService.getById(p0);
        } else {
            v1 = offsetMessage = null;
        }
        if (offsetMessage != null && !Intrinsics.areEqual((Object)offsetMessage.getChatId(), (Object)chatId)) {
            throw new NotFoundException("Message " + offsetMessageId + " is not found in chat " + chatId);
        }
        Instant instant = offsetMessage;
        if (instant == null || (instant = instant.getCreatedAt()) == null) {
            instant = offsetTimestamp;
        }
        Page messages2 = (offset = instant) != null ? ChatMessageService.getMessagesStartingAtTimestamp$default((ChatMessageService)this.chatMessageService, (ChatId)chatId, (int)limit, (LoadDirection)loadDirection, (Instant)offset, null, (boolean)includeOffsetMessage, (int)16, null) : ChatMessageService.getMessages$default((ChatMessageService)this.chatMessageService, (ChatId)chatId, (int)limit, (LoadDirection)loadDirection, null, (int)8, null);
        List list = messages2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Iterable bl = list;
        ChatMessageService chatMessageService = this.chatMessageService;
        boolean $i$f$mapNotNullToSet22 = false;
        void var14_17 = $this$mapNotNullToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ChatMessageId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            ChatMessage it = (ChatMessage)element$iv$iv;
            boolean bl3 = false;
            UserMessage userMessage = it instanceof UserMessage ? (UserMessage)it : null;
            if ((userMessage != null ? userMessage.getCitedMessageId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map citations = chatMessageService.findByIds((Set)destination$iv$iv);
        List list2 = messages2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
        Iterable $i$f$mapNotNullToSet22 = list2;
        chatMessageService = this.chatMessageService;
        boolean $i$f$mapToSet = false;
        destination$iv$iv = $this$mapToSet$iv;
        Iterable destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (ChatMessage)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl5 = false;
            collection.add(it.getId());
        }
        Map reactions2 = chatMessageService.getReactions((Iterable)((Set)destination$iv$iv2));
        List list3 = messages2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getContent(...)");
        Iterable $this$mapNotNullToSet$iv2 = CollectionsKt.plus((Collection)list3, (Iterable)citations.values());
        boolean $i$f$mapNotNullToSet = false;
        destination$iv$iv2 = $this$mapNotNullToSet$iv2;
        Object destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv2));
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator bl5 = $this$forEach$iv$iv$iv2.iterator();
        while (bl5.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = bl5.next();
            boolean bl6 = false;
            ChatMessage p0 = (ChatMessage)element$iv$iv;
            boolean bl7 = false;
            if (p0.getAuthor() == null) continue;
            boolean bl8 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        Set messageProfileIds = (Set)destination$iv$iv3;
        Map $this$flatMapToSet$iv = reactions2;
        boolean $i$f$flatMapToSet = false;
        destination$iv$iv3 = $this$flatMapToSet$iv;
        Collection destination$iv$iv4 = new LinkedHashSet($this$flatMapToSet$iv.size());
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl9 = false;
            Iterable $this$map$iv = (Iterable)it.getValue();
            boolean $i$f$map = false;
            Iterable bl7 = $this$map$iv;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void p0;
                ChatMessageReaction chatMessageReaction = (ChatMessageReaction)item$iv$iv;
                Collection collection = destination$iv$iv5;
                boolean bl10 = false;
                collection.add(p0.getAuthorId());
            }
            Iterable list$iv$iv = (List)destination$iv$iv5;
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
        }
        Set reactionProfileIds = (Set)destination$iv$iv4;
        Map profileDtos = this.findProfileDtos(SetsKt.plus((Set)messageProfileIds, (Iterable)reactionProfileIds));
        Page page = messages2.map(arg_0 -> ChatMessageApplicationService.getMessages$lambda$5(arg_0 -> ChatMessageApplicationService.getMessages$lambda$4(citations, profileDtos, this, authContext, reactions2, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"map(...)");
        return page;
    }

    public static /* synthetic */ Page getMessages$default(ChatMessageApplicationService chatMessageApplicationService, ChatId chatId, Instant instant, ChatMessageId chatMessageId, int n, LoadDirection loadDirection, boolean bl, AuthorizationContext authorizationContext, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMessages");
        }
        if ((n2 & 2) != 0) {
            instant = null;
        }
        if ((n2 & 4) != 0) {
            chatMessageId = null;
        }
        if ((n2 & 0x10) != 0) {
            loadDirection = LoadDirection.OLDER;
        }
        return chatMessageApplicationService.getMessages(chatId, instant, chatMessageId, n, loadDirection, bl, authorizationContext);
    }

    @NotNull
    public ChatMessageDto getChatMessage(@NotNull ChatId chatId, @NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext, boolean includeCitation) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        ChatMessageDto chatMessageDto = this.chatMessageService.findById(chatMessageId).filter(arg_0 -> ChatMessageApplicationService.getChatMessage$lambda$1(arg_0 -> ChatMessageApplicationService.getChatMessage$lambda$0(chatId, arg_0), arg_0)).map(arg_0 -> ChatMessageApplicationService.getChatMessage$lambda$3(arg_0 -> ChatMessageApplicationService.getChatMessage$lambda$2(includeCitation, this, chatId, authContext, arg_0), arg_0)).orElseThrow(() -> ChatMessageApplicationService.getChatMessage$lambda$4(chatMessageId, chatId));
        Intrinsics.checkNotNullExpressionValue((Object)chatMessageDto, (String)"orElseThrow(...)");
        return chatMessageDto;
    }

    public static /* synthetic */ ChatMessageDto getChatMessage$default(ChatMessageApplicationService chatMessageApplicationService, ChatId chatId, ChatMessageId chatMessageId, AuthorizationContext authorizationContext, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChatMessage");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return chatMessageApplicationService.getChatMessage(chatId, chatMessageId, authorizationContext, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ChatMessageDto edit(@NotNull ChatMessageId chatMessageId, @NotNull String newMessageText, @NotNull List<SavePersonMentionDto> newPersonMentions, @NotNull AuthorizationContext authContext) {
        Collection<PersonMention> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)newMessageText, (String)"newMessageText");
        Intrinsics.checkNotNullParameter(newPersonMentions, (String)"newPersonMentions");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!this.editChatMessages) {
            throw new NotAllowedException("Chat message edit feature is not enabled");
        }
        ChatMessage messageToEdit = this.chatMessageService.getById(chatMessageId);
        authContext.checkReadChat(messageToEdit.getChatId());
        Iterable iterable = newPersonMentions;
        String string = newMessageText;
        ChatMessage chatMessage = messageToEdit;
        ChatMessageService chatMessageService = this.chatMessageService;
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SavePersonMentionDto savePersonMentionDto = (SavePersonMentionDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SavePersonMentionDto.Companion.toPersonMention((SavePersonMentionDto)it, this.clock));
        }
        collection = (List)destination$iv$iv;
        chatMessageService.edit(chatMessage, string, (List)collection, authContext.getProfileId());
        return this.getChatMessage(messageToEdit.getChatId(), chatMessageId, authContext, true);
    }

    @NotNull
    public ChatMessageDto react(@NotNull ChatId chatId, @NotNull ChatMessageId chatMessageId, @NotNull String reaction, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!ALLOWED_REACTIONS.contains(reaction)) {
            throw new NotAllowedException("Cannot react to messages with the given emoji");
        }
        authContext.checkReadChat(chatId);
        this.chatMessageService.react(chatMessageId, chatId, authContext.getProfileId(), reaction);
        return this.getChatMessage(chatId, chatMessageId, authContext, true);
    }

    @NotNull
    public ChatMessageDto deleteReaction(@NotNull ChatId chatId, @NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        this.chatMessageService.deleteReaction(chatMessageId, chatId, authContext.getProfileId());
        return this.getChatMessage(chatId, chatMessageId, authContext, true);
    }

    /*
     * WARNING - void declaration
     */
    private Map<ProfileId, ProfileDto> findProfileDtos(Set<ProfileId> profileIds) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = this.profileService.findByIds(profileIds);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            ProfileDto profileDto = ProfileDto.Companion.toProfileDto((Profile)it.getValue());
            map3.put(k, profileDto);
        }
        return destination$iv$iv$iv;
    }

    private static final ChatMessageDto getMessages$lambda$4(Map $citations, Map $profileDtos, ChatMessageApplicationService this$0, AuthorizationContext $authContext, Map $reactions, ChatMessage chatMessage) {
        ChatMessage citation;
        ChatMessage chatMessage2 = citation = chatMessage instanceof UserMessage ? (ChatMessage)$citations.get(((UserMessage)chatMessage).getCitedMessageId()) : null;
        ChatMessageDto citationDto = chatMessage2 != null ? ChatMessageDto.Companion.toChatMessageDto$default((ChatMessageDto.Companion)ChatMessageDto.Companion, (ChatMessage)chatMessage2, (ProfileDto)Companion.access$getOrNotFound((Companion)Companion, (Map)$profileDtos, (ProfileId)citation.getAuthor()), (String)this$0.chatLocalizationService.localizeMessage(citation, $authContext), null, null, (int)12, null) : null;
        Intrinsics.checkNotNull((Object)chatMessage);
        ProfileDto profileDto = Companion.access$getOrNotFound((Companion)Companion, (Map)$profileDtos, (ProfileId)chatMessage.getAuthor());
        String string = this$0.chatLocalizationService.localizeMessage(chatMessage, $authContext);
        List list = (List)$reactions.get(chatMessage.getId());
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return ChatMessageDto.Companion.toChatMessageDto(chatMessage, profileDto, string, citationDto, Companion.access$toDtos((Companion)Companion, (List)list, (Map)$profileDtos));
    }

    private static final ChatMessageDto getMessages$lambda$5(Function1 $tmp0, Object p0) {
        return (ChatMessageDto)$tmp0.invoke(p0);
    }

    private static final boolean getChatMessage$lambda$0(ChatId $chatId, ChatMessage it) {
        return Intrinsics.areEqual((Object)it.getChatId(), (Object)$chatId);
    }

    private static final boolean getChatMessage$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final ChatMessageDto getChatMessage$lambda$2(boolean $includeCitation, ChatMessageApplicationService this$0, ChatId $chatId, AuthorizationContext $authContext, ChatMessage chatMessage) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        ChatMessageDto citedMessageDto = $includeCitation && chatMessage instanceof UserMessage && ((UserMessage)chatMessage).getCitedMessageId() != null ? ChatMessageApplicationService.getChatMessage$default((ChatMessageApplicationService)this$0, (ChatId)$chatId, (ChatMessageId)((UserMessage)chatMessage).getCitedMessageId(), (AuthorizationContext)$authContext, (boolean)false, (int)8, null) : null;
        List reactions2 = (List)this$0.chatMessageService.getReactions((Iterable)SetsKt.setOf((Object)chatMessage.getId())).get(chatMessage.getId());
        List list = reactions2;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        boolean $i$f$mapToSet = false;
        ChatMessage chatMessage2 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatMessageReaction chatMessageReaction = (ChatMessageReaction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getAuthorId());
        }
        Set reactionProfileIds = (Set)destination$iv$iv;
        Map profileDtos = this$0.findProfileDtos(SetsKt.plus((Set)reactionProfileIds, (Object)chatMessage.getAuthor()));
        ChatMessageDto.Companion companion = ChatMessageDto.Companion;
        Intrinsics.checkNotNull((Object)chatMessage);
        chatMessage2 = chatMessage;
        String string = this$0.chatLocalizationService.localizeMessage(chatMessage, $authContext);
        ProfileDto profileDto = Companion.access$getOrNotFound((Companion)Companion, (Map)profileDtos, (ProfileId)chatMessage.getAuthor());
        List list2 = reactions2;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List list3 = Companion.access$toDtos((Companion)Companion, (List)list2, (Map)profileDtos);
        return companion.toChatMessageDto(chatMessage2, profileDto, string, citedMessageDto, list3);
    }

    private static final ChatMessageDto getChatMessage$lambda$3(Function1 $tmp0, Object p0) {
        return (ChatMessageDto)$tmp0.invoke(p0);
    }

    private static final NotFoundException getChatMessage$lambda$4(ChatMessageId $chatMessageId, ChatId $chatId) {
        return new NotFoundException("ChatMessage with id " + $chatMessageId + " does not exist for chat " + $chatId);
    }

    public static final /* synthetic */ Set access$getALLOWED_REACTIONS$cp() {
        return ALLOWED_REACTIONS;
    }

    static {
        Object[] objectArray = new String[]{"\ud83d\udc4d", "\ud83c\udf89", "\ud83d\ude02", "\ud83e\udd29", "\ud83d\ude22", "\ud83d\ude2f", "\u2764\ufe0f", "\ud83d\ude4f"};
        ALLOWED_REACTIONS = SetsKt.setOf((Object[])objectArray);
    }
}

