/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence.model;

import de.justsoftware.chat.model.ChatMessagePayload;
import de.justsoftware.chat.persistence.model.DbAuditModel;
import de.justsoftware.chat.persistence.model.DbChatMessage;
import de.justsoftware.chat.persistence.model.DbChatMessageAttachment;
import de.justsoftware.chat.persistence.model.DbPersonMention;
import de.justsoftware.chat.serializer.ChatMessagePayloadConverter;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="ChatMessage")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b.\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 H2\u00020\u0001:\u0001HBk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u00109\u001a\u00020\bH\u00c6\u0003J\t\u0010:\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\u000f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u00c6\u0003J\u000b\u0010>\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010?\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003J\u0081\u0001\u0010@\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00c6\u0001J\u0013\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010DH\u00d6\u0003J\t\u0010E\u001a\u00020FH\u00d6\u0001J\t\u0010G\u001a\u00020\u0006H\u00d6\u0001R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001d\"\u0004\b%\u0010\u001fR \u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010+\"\u0004\b/\u0010-R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0017\"\u0004\b1\u0010\u0019R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u0006I"}, d2={"Lde/justsoftware/chat/persistence/model/DbChatMessage;", "Lde/justsoftware/chat/persistence/model/DbAuditModel;", "id", "Ljava/util/UUID;", "chatId", "message", "", "messageType", "Lde/justsoftware/chat/persistence/model/DbChatMessage$Companion$ChatMessageType;", "author", "payload", "Lde/justsoftware/chat/model/ChatMessagePayload;", "attachments", "", "Lde/justsoftware/chat/persistence/model/DbChatMessageAttachment;", "personMentions", "Lde/justsoftware/chat/persistence/model/DbPersonMention;", "citedMessageId", "editedAt", "Ljava/time/Instant;", "<init>", "(Ljava/util/UUID;Ljava/util/UUID;Ljava/lang/String;Lde/justsoftware/chat/persistence/model/DbChatMessage$Companion$ChatMessageType;Ljava/lang/String;Lde/justsoftware/chat/model/ChatMessagePayload;Ljava/util/List;Ljava/util/List;Ljava/util/UUID;Ljava/time/Instant;)V", "getId", "()Ljava/util/UUID;", "setId", "(Ljava/util/UUID;)V", "getChatId", "setChatId", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "getMessageType", "()Lde/justsoftware/chat/persistence/model/DbChatMessage$Companion$ChatMessageType;", "setMessageType", "(Lde/justsoftware/chat/persistence/model/DbChatMessage$Companion$ChatMessageType;)V", "getAuthor", "setAuthor", "getPayload", "()Lde/justsoftware/chat/model/ChatMessagePayload;", "setPayload", "(Lde/justsoftware/chat/model/ChatMessagePayload;)V", "getAttachments", "()Ljava/util/List;", "setAttachments", "(Ljava/util/List;)V", "getPersonMentions", "setPersonMentions", "getCitedMessageId", "setCitedMessageId", "getEditedAt", "()Ljava/time/Instant;", "setEditedAt", "(Ljava/time/Instant;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "chat-service"})
public final class DbChatMessage
extends DbAuditModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Id
    @NotNull
    private UUID id;
    @NotNull
    private UUID chatId;
    @Nullable
    private String message;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private Companion.ChatMessageType messageType;
    @NotNull
    private String author;
    @Convert(converter=ChatMessagePayloadConverter.class)
    @Nullable
    private ChatMessagePayload payload;
    @OneToMany(targetEntity=DbChatMessageAttachment.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="chatMessage", orphanRemoval=true)
    @NotNull
    private List<DbChatMessageAttachment> attachments;
    @OneToMany(targetEntity=DbPersonMention.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="chatMessage", orphanRemoval=true)
    @NotNull
    private List<DbPersonMention> personMentions;
    @Nullable
    private UUID citedMessageId;
    @Nullable
    private Instant editedAt;

    public DbChatMessage(@NotNull UUID id, @NotNull UUID chatId, @Nullable String message, @NotNull Companion.ChatMessageType messageType, @NotNull String author, @Nullable ChatMessagePayload payload, @NotNull List<DbChatMessageAttachment> attachments, @NotNull List<DbPersonMention> personMentions, @Nullable UUID citedMessageId, @Nullable Instant editedAt) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)messageType, (String)"messageType");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter(personMentions, (String)"personMentions");
        this.id = id;
        this.chatId = chatId;
        this.message = message;
        this.messageType = messageType;
        this.author = author;
        this.payload = payload;
        this.attachments = attachments;
        this.personMentions = personMentions;
        this.citedMessageId = citedMessageId;
        this.editedAt = editedAt;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    public final void setId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.id = uUID;
    }

    @NotNull
    public final UUID getChatId() {
        return this.chatId;
    }

    public final void setChatId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.chatId = uUID;
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(@Nullable String string) {
        this.message = string;
    }

    @NotNull
    public final Companion.ChatMessageType getMessageType() {
        return this.messageType;
    }

    public final void setMessageType(@NotNull Companion.ChatMessageType chatMessageType) {
        Intrinsics.checkNotNullParameter((Object)chatMessageType, (String)"<set-?>");
        this.messageType = chatMessageType;
    }

    @NotNull
    public final String getAuthor() {
        return this.author;
    }

    public final void setAuthor(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.author = string;
    }

    @Nullable
    public final ChatMessagePayload getPayload() {
        return this.payload;
    }

    public final void setPayload(@Nullable ChatMessagePayload chatMessagePayload) {
        this.payload = chatMessagePayload;
    }

    @NotNull
    public final List<DbChatMessageAttachment> getAttachments() {
        return this.attachments;
    }

    public final void setAttachments(@NotNull List<DbChatMessageAttachment> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.attachments = list;
    }

    @NotNull
    public final List<DbPersonMention> getPersonMentions() {
        return this.personMentions;
    }

    public final void setPersonMentions(@NotNull List<DbPersonMention> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.personMentions = list;
    }

    @Nullable
    public final UUID getCitedMessageId() {
        return this.citedMessageId;
    }

    public final void setCitedMessageId(@Nullable UUID uUID) {
        this.citedMessageId = uUID;
    }

    @Nullable
    public final Instant getEditedAt() {
        return this.editedAt;
    }

    public final void setEditedAt(@Nullable Instant instant) {
        this.editedAt = instant;
    }

    @NotNull
    public final UUID component1() {
        return this.id;
    }

    @NotNull
    public final UUID component2() {
        return this.chatId;
    }

    @Nullable
    public final String component3() {
        return this.message;
    }

    @NotNull
    public final Companion.ChatMessageType component4() {
        return this.messageType;
    }

    @NotNull
    public final String component5() {
        return this.author;
    }

    @Nullable
    public final ChatMessagePayload component6() {
        return this.payload;
    }

    @NotNull
    public final List<DbChatMessageAttachment> component7() {
        return this.attachments;
    }

    @NotNull
    public final List<DbPersonMention> component8() {
        return this.personMentions;
    }

    @Nullable
    public final UUID component9() {
        return this.citedMessageId;
    }

    @Nullable
    public final Instant component10() {
        return this.editedAt;
    }

    @NotNull
    public final DbChatMessage copy(@NotNull UUID id, @NotNull UUID chatId, @Nullable String message, @NotNull Companion.ChatMessageType messageType, @NotNull String author, @Nullable ChatMessagePayload payload, @NotNull List<DbChatMessageAttachment> attachments, @NotNull List<DbPersonMention> personMentions, @Nullable UUID citedMessageId, @Nullable Instant editedAt) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)messageType, (String)"messageType");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter(personMentions, (String)"personMentions");
        return new DbChatMessage(id, chatId, message, messageType, author, payload, attachments, personMentions, citedMessageId, editedAt);
    }

    public static /* synthetic */ DbChatMessage copy$default(DbChatMessage dbChatMessage, UUID uUID, UUID uUID2, String string, Companion.ChatMessageType chatMessageType, String string2, ChatMessagePayload chatMessagePayload, List list, List list2, UUID uUID3, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = dbChatMessage.id;
        }
        if ((n & 2) != 0) {
            uUID2 = dbChatMessage.chatId;
        }
        if ((n & 4) != 0) {
            string = dbChatMessage.message;
        }
        if ((n & 8) != 0) {
            chatMessageType = dbChatMessage.messageType;
        }
        if ((n & 0x10) != 0) {
            string2 = dbChatMessage.author;
        }
        if ((n & 0x20) != 0) {
            chatMessagePayload = dbChatMessage.payload;
        }
        if ((n & 0x40) != 0) {
            list = dbChatMessage.attachments;
        }
        if ((n & 0x80) != 0) {
            list2 = dbChatMessage.personMentions;
        }
        if ((n & 0x100) != 0) {
            uUID3 = dbChatMessage.citedMessageId;
        }
        if ((n & 0x200) != 0) {
            instant = dbChatMessage.editedAt;
        }
        return dbChatMessage.copy(uUID, uUID2, string, chatMessageType, string2, chatMessagePayload, list, list2, uUID3, instant);
    }

    @NotNull
    public String toString() {
        return "DbChatMessage(id=" + this.id + ", chatId=" + this.chatId + ", message=" + this.message + ", messageType=" + this.messageType + ", author=" + this.author + ", payload=" + this.payload + ", attachments=" + this.attachments + ", personMentions=" + this.personMentions + ", citedMessageId=" + this.citedMessageId + ", editedAt=" + this.editedAt + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.chatId.hashCode();
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + this.messageType.hashCode();
        result = result * 31 + this.author.hashCode();
        result = result * 31 + (this.payload == null ? 0 : this.payload.hashCode());
        result = result * 31 + ((Object)this.attachments).hashCode();
        result = result * 31 + ((Object)this.personMentions).hashCode();
        result = result * 31 + (this.citedMessageId == null ? 0 : this.citedMessageId.hashCode());
        result = result * 31 + (this.editedAt == null ? 0 : this.editedAt.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DbChatMessage)) {
            return false;
        }
        DbChatMessage dbChatMessage = (DbChatMessage)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)dbChatMessage.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.chatId, (Object)dbChatMessage.chatId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)dbChatMessage.message)) {
            return false;
        }
        if (this.messageType != dbChatMessage.messageType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.author, (Object)dbChatMessage.author)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.payload, (Object)dbChatMessage.payload)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.attachments, (Object)dbChatMessage.attachments)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.personMentions, (Object)dbChatMessage.personMentions)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.citedMessageId, (Object)dbChatMessage.citedMessageId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.editedAt, (Object)dbChatMessage.editedAt);
    }

    public DbChatMessage() {
    }
}

