/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.model.AttachmentFilter;
import de.justsoftware.chat.persistence.ChatMessageSpecifications;
import de.justsoftware.chat.persistence.model.DbChatMessage;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.time.Instant;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ \u0010\u0013\u001a\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0016\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00060\u00060\u0005H\u0002J\u0016\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00060\u00060\u0005H\u0002J\u0016\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00060\u00060\u0005H\u0002J?\u0010\u001b\u001a&\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u001d0\u001d \u0014*\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u001d0\u001d\u0018\u00010\u001c0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fH\u0002\u00a2\u0006\u0002\u0010 \u00a8\u0006!"}, d2={"Lde/justsoftware/chat/persistence/ChatMessageSpecifications;", "", "<init>", "()V", "withChatId", "Lorg/springframework/data/jpa/domain/Specification;", "Lde/justsoftware/chat/persistence/model/DbChatMessage;", "chatId", "Ljava/util/UUID;", "withChatIdIn", "chatIds", "", "createdBefore", "timestamp", "Ljava/time/Instant;", "createdBeforeOrAt", "createdAfter", "createdAfterOrAt", "updatedAfter", "withAttachments", "kotlin.jvm.PlatformType", "filter", "Lde/justsoftware/chat/business/model/AttachmentFilter;", "withAnyAttachment", "withImageAttachment", "withVideoAttachment", "withMediaAttachment", "attachmentMimeTypePath", "Ljakarta/persistence/criteria/Path;", "", "root", "Ljakarta/persistence/criteria/Root;", "(Ljakarta/persistence/criteria/Root;)Ljakarta/persistence/criteria/Path;", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatMessageSpecifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageSpecifications.kt\nde/justsoftware/chat/persistence/ChatMessageSpecifications\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n1863#3,2:110\n*S KotlinDebug\n*F\n+ 1 ChatMessageSpecifications.kt\nde/justsoftware/chat/persistence/ChatMessageSpecifications\n*L\n100#1:110,2\n*E\n"})
public final class ChatMessageSpecifications {
    @NotNull
    public static final ChatMessageSpecifications INSTANCE = new ChatMessageSpecifications();

    private ChatMessageSpecifications() {
    }

    @NotNull
    public final Specification<DbChatMessage> withChatId(@NotNull UUID chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        return (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.withChatId$lambda$0(chatId, arg_0, arg_1, arg_2);
    }

    @NotNull
    public final Specification<DbChatMessage> withChatIdIn(@NotNull Collection<UUID> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        return (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.withChatIdIn$lambda$1(chatIds, arg_0, arg_1, arg_2);
    }

    @NotNull
    public final Specification<DbChatMessage> createdBefore(@NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.createdBefore$lambda$2(timestamp, arg_0, arg_1, arg_2);
    }

    @NotNull
    public final Specification<DbChatMessage> createdBeforeOrAt(@NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.createdBeforeOrAt$lambda$3(timestamp, arg_0, arg_1, arg_2);
    }

    @NotNull
    public final Specification<DbChatMessage> createdAfter(@NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.createdAfter$lambda$4(timestamp, arg_0, arg_1, arg_2);
    }

    @NotNull
    public final Specification<DbChatMessage> createdAfterOrAt(@NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.createdAfterOrAt$lambda$5(timestamp, arg_0, arg_1, arg_2);
    }

    @Nullable
    public final Specification<DbChatMessage> updatedAfter(@Nullable Instant timestamp) {
        return timestamp != null ? (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.updatedAfter$lambda$6(timestamp, arg_0, arg_1, arg_2) : null;
    }

    @Nullable
    public final Specification<DbChatMessage> withAttachments(@Nullable AttachmentFilter filter) {
        AttachmentFilter attachmentFilter = filter;
        return switch (attachmentFilter == null ? -1 : WhenMappings.$EnumSwitchMapping$0[attachmentFilter.ordinal()]) {
            case 1 -> this.withImageAttachment();
            case 2 -> this.withVideoAttachment();
            case 3 -> this.withMediaAttachment();
            case 4 -> Specification.not((Specification)this.withMediaAttachment());
            case 5 -> this.withAnyAttachment();
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Specification<DbChatMessage> withAnyAttachment() {
        return ChatMessageSpecifications::withAnyAttachment$lambda$7;
    }

    private final Specification<DbChatMessage> withImageAttachment() {
        return ChatMessageSpecifications::withImageAttachment$lambda$8;
    }

    private final Specification<DbChatMessage> withVideoAttachment() {
        return ChatMessageSpecifications::withVideoAttachment$lambda$9;
    }

    private final Specification<DbChatMessage> withMediaAttachment() {
        return ChatMessageSpecifications::withMediaAttachment$lambda$11;
    }

    private final Path<String> attachmentMimeTypePath(Root<DbChatMessage> root) {
        return root.join("attachments").get("mimeType");
    }

    private static final Predicate withChatId$lambda$0(UUID $chatId, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.equal((Expression)root.get("chatId"), (Object)$chatId);
    }

    private static final Predicate withChatIdIn$lambda$1(Collection $chatIds, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return root.get("chatId").in($chatIds);
    }

    private static final Predicate createdBefore$lambda$2(Instant $timestamp, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.lessThan((Expression)root.get("createdAt"), (Comparable)$timestamp);
    }

    private static final Predicate createdBeforeOrAt$lambda$3(Instant $timestamp, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.lessThanOrEqualTo((Expression)root.get("createdAt"), (Comparable)$timestamp);
    }

    private static final Predicate createdAfter$lambda$4(Instant $timestamp, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.greaterThan((Expression)root.get("createdAt"), (Comparable)$timestamp);
    }

    private static final Predicate createdAfterOrAt$lambda$5(Instant $timestamp, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("createdAt"), (Comparable)$timestamp);
    }

    private static final Predicate updatedAfter$lambda$6(Instant $timestamp, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.greaterThan((Expression)root.get("updatedAt"), (Comparable)$timestamp);
    }

    private static final Predicate withAnyAttachment$lambda$7(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.isNotEmpty((Expression)root.get("attachments"));
    }

    private static final Predicate withImageAttachment$lambda$8(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNull((Object)root);
        return INSTANCE.attachmentMimeTypePath(root).in((Collection)ChatMessageService.Companion.getIMAGE_FORMATS());
    }

    private static final Predicate withVideoAttachment$lambda$9(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNull((Object)root);
        Path mimeTypePath = INSTANCE.attachmentMimeTypePath(root);
        return criteriaBuilder.like((Expression)mimeTypePath, "video/%");
    }

    private static final Predicate withMediaAttachment$lambda$11(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        CriteriaBuilder.In in;
        Intrinsics.checkNotNull((Object)root);
        Path mimeTypePath = INSTANCE.attachmentMimeTypePath(root);
        CriteriaBuilder.In $this$withMediaAttachment_u24lambda_u2411_u24lambda_u2410 = in = criteriaBuilder.in((Expression)mimeTypePath);
        boolean bl = false;
        Iterable $this$forEach$iv = ChatMessageService.Companion.getIMAGE_FORMATS();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl2 = false;
            $this$withMediaAttachment_u24lambda_u2411_u24lambda_u2410.value((Object)p0);
        }
        CriteriaBuilder.In imagePredicate = in;
        Predicate videoPredicate = criteriaBuilder.like((Expression)mimeTypePath, "video/%");
        Predicate[] predicateArray = new Predicate[]{imagePredicate, videoPredicate};
        return criteriaBuilder.or(predicateArray);
    }
}

