/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.persistence.model.DbChatMessage;
import jakarta.persistence.QueryHint;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\b\u0012\u0004\u0012\u00020\u00020\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH'J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH'J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\tH'J\u0016\u0010\u0012\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\tH'J\u0016\u0010\u0013\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0017J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u000bH'J\u001a\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001a0\u0019H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/chat/persistence/ChatMessageRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/chat/persistence/model/DbChatMessage;", "Ljava/util/UUID;", "Lorg/springframework/data/jpa/repository/JpaSpecificationExecutor;", "findUpdatedAuthorsByParticipantIdsIn", "", "", "participantIds", "", "since", "Ljava/time/Instant;", "findUpdatedAuthorsByParticipantIds", "findUpdatedReactorsByParticipantIdsIn", "findUpdatedReactorsByParticipantIds", "deleteByChatIdIn", "", "chatIds", "removeCitationFromMessagesIn", "deleteByChatIds", "updateUpdatedAt", "", "id", "updatedAt", "streamAllUserMessageIds", "Ljava/util/stream/Stream;", "Lkotlin/Pair;", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatMessageRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageRepository.kt\nde/justsoftware/chat/persistence/ChatMessageRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1368#2:130\n1454#2,5:131\n1368#2:136\n1454#2,5:137\n*S KotlinDebug\n*F\n+ 1 ChatMessageRepository.kt\nde/justsoftware/chat/persistence/ChatMessageRepository\n*L\n46#1:130\n46#1:131,5\n73#1:136\n73#1:137,5\n*E\n"})
public interface ChatMessageRepository
extends JpaRepository<DbChatMessage, UUID>,
JpaSpecificationExecutor<DbChatMessage> {
    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="findUpdatedAuthorsByParticipantIds(participantIds, since)", imports={}))
    @Query(value="\n        SELECT p.id\n        FROM DbProfile p\n        WHERE p.updatedAt > :since\n        AND EXISTS (\n            SELECT 1\n            FROM DbChatMessage m\n            JOIN DbChatParticipant cp ON m.chatId = cp.chatId\n            WHERE m.author = p.id\n            AND cp.participantId IN :participantIds\n        )\n        ")
    @NotNull
    public List<String> findUpdatedAuthorsByParticipantIdsIn(@NotNull Iterable<String> var1, @NotNull Instant var2);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<String> findUpdatedAuthorsByParticipantIds(@NotNull Iterable<String> participantIds, @NotNull Instant since) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(participantIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findUpdatedAuthorsByParticipantIdsIn((Iterable)it, since);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="findUpdatedReactorsByParticipantIds(participantIds, since)", imports={}))
    @Query(value="\n        SELECT p.id\n        FROM DbProfile p\n        WHERE p.updatedAt > :since\n        AND EXISTS (\n            SELECT 1\n            FROM DbChatMessageReaction r\n            JOIN DbChatMessage m ON r.messageId = m.id\n            JOIN DbChatParticipant cp ON m.chatId = cp.chatId\n            WHERE r.profileId = p.id\n            AND cp.participantId IN :participantIds\n        )\n        ")
    @NotNull
    public List<String> findUpdatedReactorsByParticipantIdsIn(@NotNull Iterable<String> var1, @NotNull Instant var2);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<String> findUpdatedReactorsByParticipantIds(@NotNull Iterable<String> participantIds, @NotNull Instant since) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(participantIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findUpdatedReactorsByParticipantIdsIn((Iterable)it, since);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Query(value="\n            DELETE\n            FROM DbChatMessage m\n            WHERE m.chatId IN :chatIds\n        ")
    @Modifying
    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="deleteByChatIds(chatIds)", imports={}))
    public void deleteByChatIdIn(@NotNull Iterable<UUID> var1);

    @Modifying
    @Query(value="UPDATE chat_message SET cited_message_id = null WHERE chat_id IN :chatIds", nativeQuery=true)
    public void removeCitationFromMessagesIn(@NotNull Iterable<UUID> var1);

    @Transactional
    default public void deleteByChatIds(@NotNull Iterable<UUID> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        for (List ids : CollectionsKt.chunked(chatIds, (int)1000)) {
            this.removeCitationFromMessagesIn((Iterable)ids);
            this.deleteByChatIdIn((Iterable)ids);
        }
    }

    @Modifying
    @Query(value="UPDATE chat_message SET updated_at = :updatedAt WHERE id = :id", nativeQuery=true)
    @Transactional
    public int updateUpdatedAt(@NotNull UUID var1, @NotNull Instant var2);

    @Query(value="\n        SELECT new kotlin.Pair(m.chatId, m.id) FROM DbChatMessage m\n        WHERE m.messageType = 'USER_MESSAGE'\n        ORDER BY m.chatId, m.createdAt, m.id\n    ")
    @QueryHints(value={@QueryHint(value="1000", name="org.hibernate.fetchSize"), @QueryHint(value="false", name="org.hibernate.cacheable"), @QueryHint(value="true", name="org.hibernate.readOnly")})
    @NotNull
    public Stream<Pair<UUID, UUID>> streamAllUserMessageIds();
}

