/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.application;

import de.justsoftware.chat.application.XmppApplicationService;
import de.justsoftware.chat.application.model.XmppLoginDto;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.XmppService;
import de.justsoftware.chat.business.model.xmpp.JabberId;
import de.justsoftware.jwtfilter.generator.JwtClaimsBuilder;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/chat/application/XmppApplicationService;", "", "xmppService", "Lde/justsoftware/chat/business/XmppService;", "domain", "", "ejabberdJwtGenerator", "Lde/justsoftware/jwtfilter/generator/JwtGenerator;", "<init>", "(Lde/justsoftware/chat/business/XmppService;Ljava/lang/String;Lde/justsoftware/jwtfilter/generator/JwtGenerator;)V", "clearAndSyncChatNodes", "", "getXmppLogin", "Lde/justsoftware/chat/application/model/XmppLoginDto;", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "Companion", "chat-service"})
public class XmppApplicationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XmppService xmppService;
    @NotNull
    private final String domain;
    @NotNull
    private final JwtGenerator ejabberdJwtGenerator;
    private static final long DEFAULT_LIFETIME_IN_MINUTES = 2L;

    public XmppApplicationService(@NotNull XmppService xmppService, @Value(value="${just.chat.domain}") @NotNull String domain, @Qualifier(value="ejabberdJwtGenerator") @NotNull JwtGenerator ejabberdJwtGenerator) {
        Intrinsics.checkNotNullParameter((Object)xmppService, (String)"xmppService");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)ejabberdJwtGenerator, (String)"ejabberdJwtGenerator");
        this.xmppService = xmppService;
        this.domain = domain;
        this.ejabberdJwtGenerator = ejabberdJwtGenerator;
    }

    public void clearAndSyncChatNodes() {
        this.xmppService.clearAndSyncChatNodes();
    }

    @NotNull
    public XmppLoginDto getXmppLogin(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        JabberId jabberId = JabberId.Companion.toJabberId(authContext.getProfileId(), this.domain);
        String string = this.ejabberdJwtGenerator.generateJWT(new JwtClaimsBuilder().withCustomClaim("jid", jabberId.toString()).withLifetime(2L));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateJWT(...)");
        return new XmppLoginDto(jabberId, string);
    }
}

